package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Configuration of the server's native management interface
 */
@Address("/core-service=management/management-interface=native-interface")
@ResourceType("management-interface")
@Implicit
public class NativeInterfaceManagementInterface<T extends NativeInterfaceManagementInterface<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String saslProtocol;
	private String securityRealm;
	private String serverName;
	private String socketBinding;

	public NativeInterfaceManagementInterface() {
		this.key = "native-interface";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the protocol to be passed to the SASL mechanisms used for
	 * authentication.
	 */
	@ModelNodeBinding(detypedName = "sasl-protocol")
	public String saslProtocol() {
		return this.saslProtocol;
	}

	/**
	 * The name of the protocol to be passed to the SASL mechanisms used for
	 * authentication.
	 */
	@SuppressWarnings("unchecked")
	public T saslProtocol(String value) {
		Object oldValue = this.saslProtocol;
		this.saslProtocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslProtocol", oldValue, value);
		return (T) this;
	}

	/**
	 * The security realm to use for the native management interface.
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The security realm to use for the native management interface.
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(String value) {
		Object oldValue = this.securityRealm;
		this.securityRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityRealm", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the server used in the initial Remoting exchange and within
	 * the SASL mechanisms.
	 */
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The name of the server used in the initial Remoting exchange and within
	 * the SASL mechanisms.
	 */
	@SuppressWarnings("unchecked")
	public T serverName(String value) {
		Object oldValue = this.serverName;
		this.serverName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverName", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the socket binding configuration to use for the native
	 * management interface's socket.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The name of the socket binding configuration to use for the native
	 * management interface's socket.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}
}