package org.wildfly.swarm.config.management.access.syslog_handler;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Configuration to append to syslog over udp/ip.
 */
@Address("/core-service=management/access=audit/syslog-handler=*/protocol=udp")
@ResourceType("protocol")
@Implicit
public class UdpProtocol<T extends UdpProtocol<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String host;
	private Integer port;

	public UdpProtocol() {
		this.key = "udp";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The host of the syslog server for the udp requests.
	 */
	@ModelNodeBinding(detypedName = "host")
	public String host() {
		return this.host;
	}

	/**
	 * The host of the syslog server for the udp requests.
	 */
	@SuppressWarnings("unchecked")
	public T host(String value) {
		Object oldValue = this.host;
		this.host = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("host", oldValue, value);
		return (T) this;
	}

	/**
	 * The port of the syslog server for the udp requests.
	 */
	@ModelNodeBinding(detypedName = "port")
	public Integer port() {
		return this.port;
	}

	/**
	 * The port of the syslog server for the udp requests.
	 */
	@SuppressWarnings("unchecked")
	public T port(Integer value) {
		Object oldValue = this.port;
		this.port = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("port", oldValue, value);
		return (T) this;
	}
}