package org.wildfly.swarm.config.management.access.syslog_handler.protocol;

import org.wildfly.swarm.config.management.access.syslog_handler.protocol.ClientCertificateStoreAuthentication;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ClientCertificateStoreAuthenticationConsumer<T extends ClientCertificateStoreAuthentication<T>> {

	/**
	 * Configure a pre-constructed instance of
	 * ClientCertificateStoreAuthentication resource
	 * 
	 * @parameter Instance of ClientCertificateStoreAuthentication to configure
	 * @return nothing
	 */
	void accept(T value);

	default ClientCertificateStoreAuthenticationConsumer<T> andThen(
			ClientCertificateStoreAuthenticationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}