package org.wildfly.swarm.config.management.access.syslog_handler.protocol;

import org.wildfly.swarm.config.management.access.syslog_handler.protocol.TruststoreAuthentication;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface TruststoreAuthenticationConsumer<T extends TruststoreAuthentication<T>> {

	/**
	 * Configure a pre-constructed instance of TruststoreAuthentication resource
	 * 
	 * @parameter Instance of TruststoreAuthentication to configure
	 * @return nothing
	 */
	void accept(T value);

	default TruststoreAuthenticationConsumer<T> andThen(
			TruststoreAuthenticationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}