package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.PlugIn;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface PlugInConsumer<T extends PlugIn<T>> {

	/**
	 * Configure a pre-constructed instance of PlugIn resource
	 * 
	 * @parameter Instance of PlugIn to configure
	 * @return nothing
	 */
	void accept(T value);

	default PlugInConsumer<T> andThen(PlugInConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}