package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.PropertiesAuthentication;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface PropertiesAuthenticationConsumer<T extends PropertiesAuthentication<T>> {

	/**
	 * Configure a pre-constructed instance of PropertiesAuthentication resource
	 * 
	 * @parameter Instance of PropertiesAuthentication to configure
	 * @return nothing
	 */
	void accept(T value);

	default PropertiesAuthenticationConsumer<T> andThen(
			PropertiesAuthenticationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}