package org.wildfly.swarm.config.management.security_realm.authorization;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCache;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheSupplier;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCache;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheSupplier;
/**
 * A group search where the group entry contains an attribute referencing it's
 * members.
 */
@Address("/core-service=management/security-realm=*/authorization=ldap/group-search=group-to-principal")
@ResourceType("group-search")
@Implicit
public class GroupToPrincipalGroupSearch<T extends GroupToPrincipalGroupSearch<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String baseDn;
	private String groupDnAttribute;
	private String groupName;
	private String groupNameAttribute;
	private Boolean iterative;
	private Boolean preferOriginalConnection;
	private String principalAttribute;
	private Boolean recursive;
	private String searchBy;
	private GroupToPrincipalGroupSearchResources subresources = new GroupToPrincipalGroupSearchResources();

	public GroupToPrincipalGroupSearch() {
		this.key = "group-to-principal";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The starting point of the search for the group.
	 */
	@ModelNodeBinding(detypedName = "base-dn")
	public String baseDn() {
		return this.baseDn;
	}

	/**
	 * The starting point of the search for the group.
	 */
	@SuppressWarnings("unchecked")
	public T baseDn(String value) {
		Object oldValue = this.baseDn;
		this.baseDn = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("baseDn", oldValue, value);
		return (T) this;
	}

	/**
	 * Which attribute on a group entry is it's distinguished name.
	 */
	@ModelNodeBinding(detypedName = "group-dn-attribute")
	public String groupDnAttribute() {
		return this.groupDnAttribute;
	}

	/**
	 * Which attribute on a group entry is it's distinguished name.
	 */
	@SuppressWarnings("unchecked")
	public T groupDnAttribute(String value) {
		Object oldValue = this.groupDnAttribute;
		this.groupDnAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupDnAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * An enumeration to identify if groups should be referenced using a simple
	 * name or their distinguished name.
	 */
	@ModelNodeBinding(detypedName = "group-name")
	public String groupName() {
		return this.groupName;
	}

	/**
	 * An enumeration to identify if groups should be referenced using a simple
	 * name or their distinguished name.
	 */
	@SuppressWarnings("unchecked")
	public T groupName(String value) {
		Object oldValue = this.groupName;
		this.groupName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupName", oldValue, value);
		return (T) this;
	}

	/**
	 * Which attribute on a group entry is it's simple name.
	 */
	@ModelNodeBinding(detypedName = "group-name-attribute")
	public String groupNameAttribute() {
		return this.groupNameAttribute;
	}

	/**
	 * Which attribute on a group entry is it's simple name.
	 */
	@SuppressWarnings("unchecked")
	public T groupNameAttribute(String value) {
		Object oldValue = this.groupNameAttribute;
		this.groupNameAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupNameAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * Should further searches be performed to identify groups that the groups
	 * identified are a member of?
	 */
	@ModelNodeBinding(detypedName = "iterative")
	public Boolean iterative() {
		return this.iterative;
	}

	/**
	 * Should further searches be performed to identify groups that the groups
	 * identified are a member of?
	 */
	@SuppressWarnings("unchecked")
	public T iterative(Boolean value) {
		Object oldValue = this.iterative;
		this.iterative = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("iterative", oldValue, value);
		return (T) this;
	}

	/**
	 * After following a referral should subsequent searches prefer the original
	 * connection or use the connection of the last referral.
	 */
	@ModelNodeBinding(detypedName = "prefer-original-connection")
	public Boolean preferOriginalConnection() {
		return this.preferOriginalConnection;
	}

	/**
	 * After following a referral should subsequent searches prefer the original
	 * connection or use the connection of the last referral.
	 */
	@SuppressWarnings("unchecked")
	public T preferOriginalConnection(Boolean value) {
		Object oldValue = this.preferOriginalConnection;
		this.preferOriginalConnection = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("preferOriginalConnection", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The attribute on the group entry that references the principal.
	 */
	@ModelNodeBinding(detypedName = "principal-attribute")
	public String principalAttribute() {
		return this.principalAttribute;
	}

	/**
	 * The attribute on the group entry that references the principal.
	 */
	@SuppressWarnings("unchecked")
	public T principalAttribute(String value) {
		Object oldValue = this.principalAttribute;
		this.principalAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("principalAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * Should levels below the starting point be recursively searched?
	 */
	@ModelNodeBinding(detypedName = "recursive")
	public Boolean recursive() {
		return this.recursive;
	}

	/**
	 * Should levels below the starting point be recursively searched?
	 */
	@SuppressWarnings("unchecked")
	public T recursive(Boolean value) {
		Object oldValue = this.recursive;
		this.recursive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recursive", oldValue, value);
		return (T) this;
	}

	/**
	 * Should searches be performed using simple names or distinguished names?
	 */
	@ModelNodeBinding(detypedName = "search-by")
	public String searchBy() {
		return this.searchBy;
	}

	/**
	 * Should searches be performed using simple names or distinguished names?
	 */
	@SuppressWarnings("unchecked")
	public T searchBy(String value) {
		Object oldValue = this.searchBy;
		this.searchBy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("searchBy", oldValue, value);
		return (T) this;
	}

	public GroupToPrincipalGroupSearchResources subresources() {
		return this.subresources;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCache value) {
		this.subresources.bySearchTimeCache = value;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCacheConsumer consumer) {
		BySearchTimeCache<? extends BySearchTimeCache> child = new BySearchTimeCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.bySearchTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache() {
		BySearchTimeCache<? extends BySearchTimeCache> child = new BySearchTimeCache<>();
		this.subresources.bySearchTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCacheSupplier supplier) {
		this.subresources.bySearchTimeCache = supplier.get();
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCache value) {
		this.subresources.byAccessTimeCache = value;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCacheConsumer consumer) {
		ByAccessTimeCache<? extends ByAccessTimeCache> child = new ByAccessTimeCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.byAccessTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache() {
		ByAccessTimeCache<? extends ByAccessTimeCache> child = new ByAccessTimeCache<>();
		this.subresources.byAccessTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCacheSupplier supplier) {
		this.subresources.byAccessTimeCache = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for GroupToPrincipalGroupSearch
	 */
	public static class GroupToPrincipalGroupSearchResources {
		private BySearchTimeCache bySearchTimeCache;
		private ByAccessTimeCache byAccessTimeCache;

		/**
		 * A cache to hold the results of previous LDAP interactions.
		 */
		@Subresource
		public BySearchTimeCache bySearchTimeCache() {
			return this.bySearchTimeCache;
		}

		/**
		 * A cache to hold the results of previous LDAP interactions.
		 */
		@Subresource
		public ByAccessTimeCache byAccessTimeCache() {
			return this.byAccessTimeCache;
		}
	}
}