package org.wildfly.swarm.config.management.security_realm.authorization;

import org.wildfly.swarm.config.management.security_realm.authorization.UsernameIsDnUsernameToDn;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface UsernameIsDnUsernameToDnConsumer<T extends UsernameIsDnUsernameToDn<T>> {

	/**
	 * Configure a pre-constructed instance of UsernameIsDnUsernameToDn resource
	 * 
	 * @parameter Instance of UsernameIsDnUsernameToDn to configure
	 * @return nothing
	 */
	void accept(T value);

	default UsernameIsDnUsernameToDnConsumer<T> andThen(
			UsernameIsDnUsernameToDnConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}