package org.wildfly.swarm.config.management.service;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.jboss.dmr.Property;
import java.util.Arrays;
/**
 * A currently executing operation.
 */
@Address("/core-service=management/service=management-operations/active-operation=*")
@ResourceType("active-operation")
public class ActiveOperation<T extends ActiveOperation<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String accessMechanism;
	private List<org.jboss.dmr.Property> address;
	private String callerThread;
	private Boolean cancelled;
	private Long exclusiveRunningTime;
	private String executionStatus;
	private String operation;
	private Long runningTime;

	public ActiveOperation(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The mechanism used to submit a request to the server.
	 */
	@ModelNodeBinding(detypedName = "access-mechanism")
	public String accessMechanism() {
		return this.accessMechanism;
	}

	/**
	 * The mechanism used to submit a request to the server.
	 */
	@SuppressWarnings("unchecked")
	public T accessMechanism(String value) {
		Object oldValue = this.accessMechanism;
		this.accessMechanism = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("accessMechanism", oldValue, value);
		return (T) this;
	}

	/**
	 * The address of the resource targeted by the operation. The value in the
	 * final element of the address will be '<hidden>' if the caller is not
	 * authorized to address the operation's target resource.
	 */
	@ModelNodeBinding(detypedName = "address")
	public List<Property> address() {
		return this.address;
	}

	/**
	 * The address of the resource targeted by the operation. The value in the
	 * final element of the address will be '<hidden>' if the caller is not
	 * authorized to address the operation's target resource.
	 */
	@SuppressWarnings("unchecked")
	public T address(List<org.jboss.dmr.Property> value) {
		Object oldValue = this.address;
		this.address = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("address", oldValue, value);
		return (T) this;
	}

	/**
	 * The address of the resource targeted by the operation. The value in the
	 * final element of the address will be '<hidden>' if the caller is not
	 * authorized to address the operation's target resource.
	 */
	public T address(Property value) {
		if (this.address == null) {
			this.address = new java.util.ArrayList<>();
		}
		this.address.add(value);
		return (T) this;
	}

	/**
	 * The address of the resource targeted by the operation. The value in the
	 * final element of the address will be '<hidden>' if the caller is not
	 * authorized to address the operation's target resource.
	 */
	@SuppressWarnings("unchecked")
	public T address(Property... args) {
		address(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The name of the thread that is executing the operation.
	 */
	@ModelNodeBinding(detypedName = "caller-thread")
	public String callerThread() {
		return this.callerThread;
	}

	/**
	 * The name of the thread that is executing the operation.
	 */
	@SuppressWarnings("unchecked")
	public T callerThread(String value) {
		Object oldValue = this.callerThread;
		this.callerThread = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("callerThread", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the operation has been cancelled.
	 */
	@ModelNodeBinding(detypedName = "cancelled")
	public Boolean cancelled() {
		return this.cancelled;
	}

	/**
	 * Whether the operation has been cancelled.
	 */
	@SuppressWarnings("unchecked")
	public T cancelled(Boolean value) {
		Object oldValue = this.cancelled;
		this.cancelled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cancelled", oldValue, value);
		return (T) this;
	}

	/**
	 * Amount of time the operation has been executing with the exclusive
	 * operation execution lock held, or -1 if the operation does not hold the
	 * exclusive execution lock.
	 */
	@ModelNodeBinding(detypedName = "exclusive-running-time")
	public Long exclusiveRunningTime() {
		return this.exclusiveRunningTime;
	}

	/**
	 * Amount of time the operation has been executing with the exclusive
	 * operation execution lock held, or -1 if the operation does not hold the
	 * exclusive execution lock.
	 */
	@SuppressWarnings("unchecked")
	public T exclusiveRunningTime(Long value) {
		Object oldValue = this.exclusiveRunningTime;
		this.exclusiveRunningTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("exclusiveRunningTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The current activity of the operation.
	 */
	@ModelNodeBinding(detypedName = "execution-status")
	public String executionStatus() {
		return this.executionStatus;
	}

	/**
	 * The current activity of the operation.
	 */
	@SuppressWarnings("unchecked")
	public T executionStatus(String value) {
		Object oldValue = this.executionStatus;
		this.executionStatus = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("executionStatus", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the operation, or '<hidden>' if the caller is not authorized
	 * to address the operation's target resource.
	 */
	@ModelNodeBinding(detypedName = "operation")
	public String operation() {
		return this.operation;
	}

	/**
	 * The name of the operation, or '<hidden>' if the caller is not authorized
	 * to address the operation's target resource.
	 */
	@SuppressWarnings("unchecked")
	public T operation(String value) {
		Object oldValue = this.operation;
		this.operation = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("operation", oldValue, value);
		return (T) this;
	}

	/**
	 * Amount of time the operation has been executing.
	 */
	@ModelNodeBinding(detypedName = "running-time")
	public Long runningTime() {
		return this.runningTime;
	}

	/**
	 * Amount of time the operation has been executing.
	 */
	@SuppressWarnings("unchecked")
	public T runningTime(Long value) {
		Object oldValue = this.runningTime;
		this.runningTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("runningTime", oldValue, value);
		return (T) this;
	}
}