package org.wildfly.swarm.config.messaging_activemq;

import org.wildfly.swarm.config.messaging_activemq.Server;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ServerConsumer<T extends Server<T>> {

	/**
	 * Configure a pre-constructed instance of Server resource
	 * 
	 * @parameter Instance of Server to configure
	 * @return nothing
	 */
	void accept(T value);

	default ServerConsumer<T> andThen(ServerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}