package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.BindingsDirectoryPath;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface BindingsDirectoryPathConsumer<T extends BindingsDirectoryPath<T>> {

	/**
	 * Configure a pre-constructed instance of BindingsDirectoryPath resource
	 * 
	 * @parameter Instance of BindingsDirectoryPath to configure
	 * @return nothing
	 */
	void accept(T value);

	default BindingsDirectoryPathConsumer<T> andThen(
			BindingsDirectoryPathConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}