package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ClusterConnectionConsumer<T extends ClusterConnection<T>> {

	/**
	 * Configure a pre-constructed instance of ClusterConnection resource
	 * 
	 * @parameter Instance of ClusterConnection to configure
	 * @return nothing
	 */
	void accept(T value);

	default ClusterConnectionConsumer<T> andThen(
			ClusterConnectionConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}