package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ConnectionFactoryConsumer<T extends ConnectionFactory<T>> {

	/**
	 * Configure a pre-constructed instance of ConnectionFactory resource
	 * 
	 * @parameter Instance of ConnectionFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConnectionFactoryConsumer<T> andThen(
			ConnectionFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}