package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.CoreAddress;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface CoreAddressConsumer<T extends CoreAddress<T>> {

	/**
	 * Configure a pre-constructed instance of CoreAddress resource
	 * 
	 * @parameter Instance of CoreAddress to configure
	 * @return nothing
	 */
	void accept(T value);

	default CoreAddressConsumer<T> andThen(CoreAddressConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}