package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.Divert;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface DivertConsumer<T extends Divert<T>> {

	/**
	 * Configure a pre-constructed instance of Divert resource
	 * 
	 * @parameter Instance of Divert to configure
	 * @return nothing
	 */
	void accept(T value);

	default DivertConsumer<T> andThen(DivertConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}