package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.InVMConnector;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface InVMConnectorConsumer<T extends InVMConnector<T>> {

	/**
	 * Configure a pre-constructed instance of InVMConnector resource
	 * 
	 * @parameter Instance of InVMConnector to configure
	 * @return nothing
	 */
	void accept(T value);

	default InVMConnectorConsumer<T> andThen(InVMConnectorConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}