package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface RemoteConnectorConsumer<T extends RemoteConnector<T>> {

	/**
	 * Configure a pre-constructed instance of RemoteConnector resource
	 * 
	 * @parameter Instance of RemoteConnector to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemoteConnectorConsumer<T> andThen(RemoteConnectorConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}