package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The policy configuration.
 */
@Addresses({
		"/subsystem=remoting/http-connector=*/security=sasl/sasl-policy=policy",
		"/subsystem=remoting/connector=*/security=sasl/sasl-policy=policy"})
@ResourceType("sasl-policy")
@Implicit
public class PolicySASLPolicy<T extends PolicySASLPolicy<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean forwardSecrecy;
	private Boolean noActive;
	private Boolean noAnonymous;
	private Boolean noDictionary;
	private Boolean noPlainText;
	private Boolean passCredentials;

	public PolicySASLPolicy() {
		this.key = "policy";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The optional nested "forward-secrecy" element contains a boolean value
	 * which specifies whether mechanisms that implement forward secrecy between
	 * sessions are required. Forward secrecy means that breaking into one
	 * session will not automatically provide information for breaking into
	 * future sessions.
	 */
	@ModelNodeBinding(detypedName = "forward-secrecy")
	public Boolean forwardSecrecy() {
		return this.forwardSecrecy;
	}

	/**
	 * The optional nested "forward-secrecy" element contains a boolean value
	 * which specifies whether mechanisms that implement forward secrecy between
	 * sessions are required. Forward secrecy means that breaking into one
	 * session will not automatically provide information for breaking into
	 * future sessions.
	 */
	@SuppressWarnings("unchecked")
	public T forwardSecrecy(Boolean value) {
		Object oldValue = this.forwardSecrecy;
		this.forwardSecrecy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("forwardSecrecy", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional nested "no-active" element contains a boolean value which
	 * specifies whether mechanisms susceptible to active (non-dictionary)
	 * attacks are not permitted. "false" to permit, "true" to deny.
	 */
	@ModelNodeBinding(detypedName = "no-active")
	public Boolean noActive() {
		return this.noActive;
	}

	/**
	 * The optional nested "no-active" element contains a boolean value which
	 * specifies whether mechanisms susceptible to active (non-dictionary)
	 * attacks are not permitted. "false" to permit, "true" to deny.
	 */
	@SuppressWarnings("unchecked")
	public T noActive(Boolean value) {
		Object oldValue = this.noActive;
		this.noActive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("noActive", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional nested "no-anonymous" element contains a boolean value which
	 * specifies whether mechanisms that accept anonymous login are permitted.
	 * "false" to permit, "true" to deny.
	 */
	@ModelNodeBinding(detypedName = "no-anonymous")
	public Boolean noAnonymous() {
		return this.noAnonymous;
	}

	/**
	 * The optional nested "no-anonymous" element contains a boolean value which
	 * specifies whether mechanisms that accept anonymous login are permitted.
	 * "false" to permit, "true" to deny.
	 */
	@SuppressWarnings("unchecked")
	public T noAnonymous(Boolean value) {
		Object oldValue = this.noAnonymous;
		this.noAnonymous = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("noAnonymous", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional nested "no-dictionary" element contains a boolean value
	 * which specifies whether mechanisms susceptible to passive dictionary
	 * attacks are permitted. "false" to permit, "true" to deny.
	 */
	@ModelNodeBinding(detypedName = "no-dictionary")
	public Boolean noDictionary() {
		return this.noDictionary;
	}

	/**
	 * The optional nested "no-dictionary" element contains a boolean value
	 * which specifies whether mechanisms susceptible to passive dictionary
	 * attacks are permitted. "false" to permit, "true" to deny.
	 */
	@SuppressWarnings("unchecked")
	public T noDictionary(Boolean value) {
		Object oldValue = this.noDictionary;
		this.noDictionary = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("noDictionary", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional nested "no-plain-text" element contains a boolean value
	 * which specifies whether mechanisms susceptible to simple plain passive
	 * attacks (e.g., "PLAIN") are not permitted. "false" to permit, "true" to
	 * deny.
	 */
	@ModelNodeBinding(detypedName = "no-plain-text")
	public Boolean noPlainText() {
		return this.noPlainText;
	}

	/**
	 * The optional nested "no-plain-text" element contains a boolean value
	 * which specifies whether mechanisms susceptible to simple plain passive
	 * attacks (e.g., "PLAIN") are not permitted. "false" to permit, "true" to
	 * deny.
	 */
	@SuppressWarnings("unchecked")
	public T noPlainText(Boolean value) {
		Object oldValue = this.noPlainText;
		this.noPlainText = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("noPlainText", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional nested "pass-credentials" element contains a boolean value
	 * which specifies whether mechanisms that pass client credentials are
	 * required.
	 */
	@ModelNodeBinding(detypedName = "pass-credentials")
	public Boolean passCredentials() {
		return this.passCredentials;
	}

	/**
	 * The optional nested "pass-credentials" element contains a boolean value
	 * which specifies whether mechanisms that pass client credentials are
	 * required.
	 */
	@SuppressWarnings("unchecked")
	public T passCredentials(Boolean value) {
		Object oldValue = this.passCredentials;
		this.passCredentials = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("passCredentials", oldValue, value);
		return (T) this;
	}
}