package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.remoting.PolicySASLPolicy;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface PolicySASLPolicyConsumer<T extends PolicySASLPolicy<T>> {

	/**
	 * Configure a pre-constructed instance of PolicySASLPolicy resource
	 * 
	 * @parameter Instance of PolicySASLPolicy to configure
	 * @return nothing
	 */
	void accept(T value);

	default PolicySASLPolicyConsumer<T> andThen(
			PolicySASLPolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}