package org.wildfly.swarm.config.security.security_domain.authentication;

import org.wildfly.swarm.config.security.security_domain.authentication.AuthModule;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface AuthModuleConsumer<T extends AuthModule<T>> {

	/**
	 * Configure a pre-constructed instance of AuthModule resource
	 * 
	 * @parameter Instance of AuthModule to configure
	 * @return nothing
	 */
	void accept(T value);

	default AuthModuleConsumer<T> andThen(AuthModuleConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}