package org.wildfly.swarm.config.webservices;

import org.wildfly.swarm.config.webservices.EndpointConfig;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface EndpointConfigConsumer<T extends EndpointConfig<T>> {

	/**
	 * Configure a pre-constructed instance of EndpointConfig resource
	 * 
	 * @parameter Instance of EndpointConfig to configure
	 * @return nothing
	 */
	void accept(T value);

	default EndpointConfigConsumer<T> andThen(EndpointConfigConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}