/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.swarm.config.management.access.ApplicationClassificationConstraint;
import org.wildfly.swarm.config.management.access.ApplicationClassificationConstraintConsumer;
import org.wildfly.swarm.config.management.access.ApplicationClassificationConstraintSupplier;
import org.wildfly.swarm.config.management.access.RoleMapping;
import org.wildfly.swarm.config.management.access.RoleMappingConsumer;
import org.wildfly.swarm.config.management.access.RoleMappingSupplier;
import org.wildfly.swarm.config.management.access.SensitivityClassificationConstraint;
import org.wildfly.swarm.config.management.access.SensitivityClassificationConstraintConsumer;
import org.wildfly.swarm.config.management.access.SensitivityClassificationConstraintSupplier;
import org.wildfly.swarm.config.management.access.VaultExpressionConstraint;
import org.wildfly.swarm.config.management.access.VaultExpressionConstraintConsumer;
import org.wildfly.swarm.config.management.access.VaultExpressionConstraintSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/core-service=management/access=authorization")
@ResourceType(value="access")
@Implicit
public class AuthorizationAccess<T extends AuthorizationAccess<T>> {
    private String key = "authorization";
    private PropertyChangeSupport pcs;
    private List<String> allRoleNames;
    private String permissionCombinationPolicy;
    private String provider;
    private List<String> standardRoleNames;
    private AuthorizationAccessResources subresources = new AuthorizationAccessResources();

    public AuthorizationAccess() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="all-role-names")
    public List<String> allRoleNames() {
        return this.allRoleNames;
    }

    public T allRoleNames(List<String> value) {
        List<String> oldValue = this.allRoleNames;
        this.allRoleNames = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allRoleNames", oldValue, value);
        }
        return (T)this;
    }

    public T allRoleName(String value) {
        if (this.allRoleNames == null) {
            this.allRoleNames = new ArrayList<String>();
        }
        this.allRoleNames.add(value);
        return (T)this;
    }

    public T allRoleNames(String ... args) {
        this.allRoleNames(Arrays.asList(args));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="permission-combination-policy")
    public String permissionCombinationPolicy() {
        return this.permissionCombinationPolicy;
    }

    public T permissionCombinationPolicy(String value) {
        String oldValue = this.permissionCombinationPolicy;
        this.permissionCombinationPolicy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("permissionCombinationPolicy", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="provider")
    public String provider() {
        return this.provider;
    }

    public T provider(String value) {
        String oldValue = this.provider;
        this.provider = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("provider", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="standard-role-names")
    public List<String> standardRoleNames() {
        return this.standardRoleNames;
    }

    public T standardRoleNames(List<String> value) {
        List<String> oldValue = this.standardRoleNames;
        this.standardRoleNames = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("standardRoleNames", oldValue, value);
        }
        return (T)this;
    }

    public T standardRoleName(String value) {
        if (this.standardRoleNames == null) {
            this.standardRoleNames = new ArrayList<String>();
        }
        this.standardRoleNames.add(value);
        return (T)this;
    }

    public T standardRoleNames(String ... args) {
        this.standardRoleNames(Arrays.asList(args));
        return (T)this;
    }

    public AuthorizationAccessResources subresources() {
        return this.subresources;
    }

    public T roleMappings(List<RoleMapping> value) {
        this.subresources.roleMappings = value;
        return (T)this;
    }

    public T roleMapping(RoleMapping value) {
        this.subresources.roleMappings.add(value);
        return (T)this;
    }

    public T roleMapping(String childKey, RoleMappingConsumer consumer) {
        RoleMapping child = new RoleMapping(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.roleMapping(child);
        return (T)this;
    }

    public T roleMapping(String childKey) {
        this.roleMapping(childKey, null);
        return (T)this;
    }

    public T roleMapping(RoleMappingSupplier supplier) {
        this.roleMapping(supplier.get());
        return (T)this;
    }

    public T vaultExpressionConstraint(VaultExpressionConstraint value) {
        this.subresources.vaultExpressionConstraint = value;
        return (T)this;
    }

    public T vaultExpressionConstraint(VaultExpressionConstraintConsumer consumer) {
        VaultExpressionConstraint child = new VaultExpressionConstraint();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.vaultExpressionConstraint = child;
        return (T)this;
    }

    public T vaultExpressionConstraint() {
        VaultExpressionConstraint child = new VaultExpressionConstraint();
        this.subresources.vaultExpressionConstraint = child;
        return (T)this;
    }

    public T vaultExpressionConstraint(VaultExpressionConstraintSupplier supplier) {
        this.subresources.vaultExpressionConstraint = supplier.get();
        return (T)this;
    }

    public T applicationClassificationConstraint(ApplicationClassificationConstraint value) {
        this.subresources.applicationClassificationConstraint = value;
        return (T)this;
    }

    public T applicationClassificationConstraint(ApplicationClassificationConstraintConsumer consumer) {
        ApplicationClassificationConstraint child = new ApplicationClassificationConstraint();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.applicationClassificationConstraint = child;
        return (T)this;
    }

    public T applicationClassificationConstraint() {
        ApplicationClassificationConstraint child = new ApplicationClassificationConstraint();
        this.subresources.applicationClassificationConstraint = child;
        return (T)this;
    }

    public T applicationClassificationConstraint(ApplicationClassificationConstraintSupplier supplier) {
        this.subresources.applicationClassificationConstraint = supplier.get();
        return (T)this;
    }

    public T sensitivityClassificationConstraint(SensitivityClassificationConstraint value) {
        this.subresources.sensitivityClassificationConstraint = value;
        return (T)this;
    }

    public T sensitivityClassificationConstraint(SensitivityClassificationConstraintConsumer consumer) {
        SensitivityClassificationConstraint child = new SensitivityClassificationConstraint();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.sensitivityClassificationConstraint = child;
        return (T)this;
    }

    public T sensitivityClassificationConstraint() {
        SensitivityClassificationConstraint child = new SensitivityClassificationConstraint();
        this.subresources.sensitivityClassificationConstraint = child;
        return (T)this;
    }

    public T sensitivityClassificationConstraint(SensitivityClassificationConstraintSupplier supplier) {
        this.subresources.sensitivityClassificationConstraint = supplier.get();
        return (T)this;
    }

    public static class AuthorizationAccessResources {
        private List<RoleMapping> roleMappings = new ArrayList<RoleMapping>();
        private VaultExpressionConstraint vaultExpressionConstraint;
        private ApplicationClassificationConstraint applicationClassificationConstraint;
        private SensitivityClassificationConstraint sensitivityClassificationConstraint;

        @Subresource
        public List<RoleMapping> roleMappings() {
            return this.roleMappings;
        }

        public RoleMapping roleMapping(String key) {
            return this.roleMappings.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public VaultExpressionConstraint vaultExpressionConstraint() {
            return this.vaultExpressionConstraint;
        }

        @Subresource
        public ApplicationClassificationConstraint applicationClassificationConstraint() {
            return this.applicationClassificationConstraint;
        }

        @Subresource
        public SensitivityClassificationConstraint sensitivityClassificationConstraint() {
            return this.sensitivityClassificationConstraint;
        }
    }
}

