/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.security_domain;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule;
import org.wildfly.swarm.config.security.security_domain.authorization.PolicyModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.authorization.PolicyModuleSupplier;

@Address(value="/subsystem=security/security-domain=*/authorization=classic")
@ResourceType(value="authorization")
@Implicit
public class ClassicAuthorization<T extends ClassicAuthorization<T>> {
    private String key = "classic";
    private PropertyChangeSupport pcs;
    private ClassicAuthorizationResources subresources = new ClassicAuthorizationResources();

    public ClassicAuthorization() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ClassicAuthorizationResources subresources() {
        return this.subresources;
    }

    public T policyModules(List<PolicyModule> value) {
        this.subresources.policyModules = value;
        return (T)this;
    }

    public T policyModule(PolicyModule value) {
        this.subresources.policyModules.add(value);
        return (T)this;
    }

    public T policyModule(String childKey, PolicyModuleConsumer consumer) {
        PolicyModule child = new PolicyModule(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.policyModule(child);
        return (T)this;
    }

    public T policyModule(String childKey) {
        this.policyModule(childKey, null);
        return (T)this;
    }

    public T policyModule(PolicyModuleSupplier supplier) {
        this.policyModule(supplier.get());
        return (T)this;
    }

    public static class ClassicAuthorizationResources {
        private List<PolicyModule> policyModules = new ArrayList<PolicyModule>();

        @Subresource
        public List<PolicyModule> policyModules() {
            return this.policyModules;
        }

        public PolicyModule policyModule(String key) {
            return this.policyModules.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

