package org.wildfly.swarm.config;

import org.wildfly.swarm.config.SecurityManager;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SecurityManagerConsumer<T extends SecurityManager<T>> {

	/**
	 * Configure a pre-constructed instance of SecurityManager resource
	 * 
	 * @parameter Instance of SecurityManager to configure
	 * @return nothing
	 */
	void accept(T value);

	default SecurityManagerConsumer<T> andThen(SecurityManagerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}