package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Weld;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface WeldConsumer<T extends Weld<T>> {

	/**
	 * Configure a pre-constructed instance of Weld resource
	 * 
	 * @parameter Instance of Weld to configure
	 * @return nothing
	 */
	void accept(T value);

	default WeldConsumer<T> andThen(WeldConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}