package org.wildfly.swarm.config.batch.jberet;

import org.wildfly.swarm.config.batch.jberet.InMemoryJobRepository;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface InMemoryJobRepositoryConsumer<T extends InMemoryJobRepository<T>> {

	/**
	 * Configure a pre-constructed instance of InMemoryJobRepository resource
	 * 
	 * @parameter Instance of InMemoryJobRepository to configure
	 * @return nothing
	 */
	void accept(T value);

	default InMemoryJobRepositoryConsumer<T> andThen(
			InMemoryJobRepositoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}