package org.wildfly.swarm.config.datasources;
public enum FlushStrategy {
	UNKNOWN("UNKNOWN"), FAILINGCONNECTIONONLY("FailingConnectionOnly"), INVALIDIDLECONNECTIONS(
			"InvalidIdleConnections"), IDLECONNECTIONS("IdleConnections"), GRACEFULLY(
			"Gracefully"), ENTIREPOOL("EntirePool"), ALLINVALIDIDLECONNECTIONS(
			"AllInvalidIdleConnections"), ALLIDLECONNECTIONS(
			"AllIdleConnections"), ALLGRACEFULLY("AllGracefully"), ALLCONNECTIONS(
			"AllConnections");

	private final String allowedValue;

	/**
	 * Returns the allowed value for the management model.
	 * 
	 * @return the allowed model value
	 */
	public String getAllowedValue() {
		return allowedValue;
	}

	FlushStrategy(String allowedValue) {
		this.allowedValue = allowedValue;
	}

	@Override
	public String toString() {
		return allowedValue;
	}
}