package org.wildfly.swarm.config.ee;

import org.wildfly.swarm.config.ee.ManagedScheduledExecutorService;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ManagedScheduledExecutorServiceConsumer<T extends ManagedScheduledExecutorService<T>> {

	/**
	 * Configure a pre-constructed instance of ManagedScheduledExecutorService
	 * resource
	 * 
	 * @parameter Instance of ManagedScheduledExecutorService to configure
	 * @return nothing
	 */
	void accept(T value);

	default ManagedScheduledExecutorServiceConsumer<T> andThen(
			ManagedScheduledExecutorServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}