package org.wildfly.swarm.config.ee;
public enum RejectPolicy {
	ABORT("ABORT"), RETRY_ABORT("RETRY_ABORT");

	private final String allowedValue;

	/**
	 * Returns the allowed value for the management model.
	 * 
	 * @return the allowed model value
	 */
	public String getAllowedValue() {
		return allowedValue;
	}

	RejectPolicy(String allowedValue) {
		this.allowedValue = allowedValue;
	}

	@Override
	public String toString() {
		return allowedValue;
	}
}