package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.ejb3.RemoteService;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface RemoteServiceConsumer<T extends RemoteService<T>> {

	/**
	 * Configure a pre-constructed instance of RemoteService resource
	 * 
	 * @parameter Instance of RemoteService to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemoteServiceConsumer<T> andThen(RemoteServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}