package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The partition handling configuration for distributed and replicated caches.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/component=partition-handling",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/component=partition-handling"})
@ResourceType("component")
@Implicit
public class PartitionHandlingComponent<T extends PartitionHandlingComponent<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String availability;
	private Boolean enabled;

	public PartitionHandlingComponent() {
		this.key = "partition-handling";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Indicates the current availability of the cache.
	 */
	@ModelNodeBinding(detypedName = "availability")
	public String availability() {
		return this.availability;
	}

	/**
	 * Indicates the current availability of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T availability(String value) {
		Object oldValue = this.availability;
		this.availability = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("availability", oldValue, value);
		return (T) this;
	}

	/**
	 * If enabled, the cache will enter degraded mode upon detecting a network
	 * partition that threatens the integrity of the cache.
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * If enabled, the cache will enter degraded mode upon detecting a network
	 * partition that threatens the integrity of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T enabled(Boolean value) {
		Object oldValue = this.enabled;
		this.enabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabled", oldValue, value);
		return (T) this;
	}
}