package org.wildfly.swarm.config.io;

import org.wildfly.swarm.config.io.BufferPool;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface BufferPoolConsumer<T extends BufferPool<T>> {

	/**
	 * Configure a pre-constructed instance of BufferPool resource
	 * 
	 * @parameter Instance of BufferPool to configure
	 * @return nothing
	 */
	void accept(T value);

	default BufferPoolConsumer<T> andThen(BufferPoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}