package org.wildfly.swarm.config.io;

import org.wildfly.swarm.config.io.Worker;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface WorkerConsumer<T extends Worker<T>> {

	/**
	 * Configure a pre-constructed instance of Worker resource
	 * 
	 * @parameter Instance of Worker to configure
	 * @return nothing
	 */
	void accept(T value);

	default WorkerConsumer<T> andThen(WorkerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}