package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.jca.ArchiveValidation;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ArchiveValidationConsumer<T extends ArchiveValidation<T>> {

	/**
	 * Configure a pre-constructed instance of ArchiveValidation resource
	 * 
	 * @parameter Instance of ArchiveValidation to configure
	 * @return nothing
	 */
	void accept(T value);

	default ArchiveValidationConsumer<T> andThen(
			ArchiveValidationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}