package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.jca.BeanValidation;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface BeanValidationConsumer<T extends BeanValidation<T>> {

	/**
	 * Configure a pre-constructed instance of BeanValidation resource
	 * 
	 * @parameter Instance of BeanValidation to configure
	 * @return nothing
	 */
	void accept(T value);

	default BeanValidationConsumer<T> andThen(BeanValidationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}