package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.jca.BootstrapContext;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface BootstrapContextConsumer<T extends BootstrapContext<T>> {

	/**
	 * Configure a pre-constructed instance of BootstrapContext resource
	 * 
	 * @parameter Instance of BootstrapContext to configure
	 * @return nothing
	 */
	void accept(T value);

	default BootstrapContextConsumer<T> andThen(
			BootstrapContextConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}