package org.wildfly.swarm.config.jgroups.stack.transport;

import org.wildfly.swarm.config.jgroups.stack.transport.OobThreadPool;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface OobThreadPoolConsumer<T extends OobThreadPool<T>> {

	/**
	 * Configure a pre-constructed instance of OobThreadPool resource
	 * 
	 * @parameter Instance of OobThreadPool to configure
	 * @return nothing
	 */
	void accept(T value);

	default OobThreadPoolConsumer<T> andThen(OobThreadPoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}