package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.management.access.SizeRotatingFileHandler;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SizeRotatingFileHandlerConsumer<T extends SizeRotatingFileHandler<T>> {

	/**
	 * Configure a pre-constructed instance of SizeRotatingFileHandler resource
	 * 
	 * @parameter Instance of SizeRotatingFileHandler to configure
	 * @return nothing
	 */
	void accept(T value);

	default SizeRotatingFileHandlerConsumer<T> andThen(
			SizeRotatingFileHandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}