package org.wildfly.swarm.config.management.access.constraint.application_classification.type;

import org.wildfly.swarm.config.management.access.constraint.application_classification.type.Classification;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ClassificationConsumer<T extends Classification<T>> {

	/**
	 * Configure a pre-constructed instance of Classification resource
	 * 
	 * @parameter Instance of Classification to configure
	 * @return nothing
	 */
	void accept(T value);

	default ClassificationConsumer<T> andThen(ClassificationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}