package org.wildfly.swarm.config.management.access.role_mapping;

import org.wildfly.swarm.config.management.access.role_mapping.Exclude;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ExcludeConsumer<T extends Exclude<T>> {

	/**
	 * Configure a pre-constructed instance of Exclude resource
	 * 
	 * @parameter Instance of Exclude to configure
	 * @return nothing
	 */
	void accept(T value);

	default ExcludeConsumer<T> andThen(ExcludeConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}