package org.wildfly.swarm.config.management.access.syslog_handler;

import org.wildfly.swarm.config.management.access.syslog_handler.UdpProtocol;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface UdpProtocolConsumer<T extends UdpProtocol<T>> {

	/**
	 * Configure a pre-constructed instance of UdpProtocol resource
	 * 
	 * @parameter Instance of UdpProtocol to configure
	 * @return nothing
	 */
	void accept(T value);

	default UdpProtocolConsumer<T> andThen(UdpProtocolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}