package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.LocalAuthentication;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface LocalAuthenticationConsumer<T extends LocalAuthentication<T>> {

	/**
	 * Configure a pre-constructed instance of LocalAuthentication resource
	 * 
	 * @parameter Instance of LocalAuthentication to configure
	 * @return nothing
	 */
	void accept(T value);

	default LocalAuthenticationConsumer<T> andThen(
			LocalAuthenticationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}