package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.PlugInAuthentication;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface PlugInAuthenticationConsumer<T extends PlugInAuthentication<T>> {

	/**
	 * Configure a pre-constructed instance of PlugInAuthentication resource
	 * 
	 * @parameter Instance of PlugInAuthentication to configure
	 * @return nothing
	 */
	void accept(T value);

	default PlugInAuthenticationConsumer<T> andThen(
			PlugInAuthenticationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}