package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.PlugInAuthorization;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface PlugInAuthorizationConsumer<T extends PlugInAuthorization<T>> {

	/**
	 * Configure a pre-constructed instance of PlugInAuthorization resource
	 * 
	 * @parameter Instance of PlugInAuthorization to configure
	 * @return nothing
	 */
	void accept(T value);

	default PlugInAuthorizationConsumer<T> andThen(
			PlugInAuthorizationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}