package org.wildfly.swarm.config.management.security_realm.authentication;

import org.wildfly.swarm.config.management.security_realm.authentication.User;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface UserConsumer<T extends User<T>> {

	/**
	 * Configure a pre-constructed instance of User resource
	 * 
	 * @parameter Instance of User to configure
	 * @return nothing
	 */
	void accept(T value);

	default UserConsumer<T> andThen(UserConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}