package org.wildfly.swarm.config.management.security_realm.authorization;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCache;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheSupplier;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCache;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheSupplier;
/**
 * A simple filter configuration to identify the users distinguished name from
 * their username.
 */
@Address("/core-service=management/security-realm=*/authorization=ldap/username-to-dn=username-filter")
@ResourceType("username-to-dn")
@Implicit
public class UsernameFilterUsernameToDn<T extends UsernameFilterUsernameToDn<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String attribute;
	private String baseDn;
	private Boolean force;
	private Boolean recursive;
	private String userDnAttribute;
	private UsernameFilterUsernameToDnResources subresources = new UsernameFilterUsernameToDnResources();

	public UsernameFilterUsernameToDn() {
		this.key = "username-filter";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The attribute on the user entry that is their username.
	 */
	@ModelNodeBinding(detypedName = "attribute")
	public String attribute() {
		return this.attribute;
	}

	/**
	 * The attribute on the user entry that is their username.
	 */
	@SuppressWarnings("unchecked")
	public T attribute(String value) {
		Object oldValue = this.attribute;
		this.attribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attribute", oldValue, value);
		return (T) this;
	}

	/**
	 * The starting point of the search for the user.
	 */
	@ModelNodeBinding(detypedName = "base-dn")
	public String baseDn() {
		return this.baseDn;
	}

	/**
	 * The starting point of the search for the user.
	 */
	@SuppressWarnings("unchecked")
	public T baseDn(String value) {
		Object oldValue = this.baseDn;
		this.baseDn = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("baseDn", oldValue, value);
		return (T) this;
	}

	/**
	 * Authentication may have already converted the username to a distinguished
	 * name, force this to occur again before loading groups.
	 */
	@ModelNodeBinding(detypedName = "force")
	public Boolean force() {
		return this.force;
	}

	/**
	 * Authentication may have already converted the username to a distinguished
	 * name, force this to occur again before loading groups.
	 */
	@SuppressWarnings("unchecked")
	public T force(Boolean value) {
		Object oldValue = this.force;
		this.force = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("force", oldValue, value);
		return (T) this;
	}

	/**
	 * Should levels below the starting point be recursively searched?
	 */
	@ModelNodeBinding(detypedName = "recursive")
	public Boolean recursive() {
		return this.recursive;
	}

	/**
	 * Should levels below the starting point be recursively searched?
	 */
	@SuppressWarnings("unchecked")
	public T recursive(Boolean value) {
		Object oldValue = this.recursive;
		this.recursive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recursive", oldValue, value);
		return (T) this;
	}

	/**
	 * The attribute on the user entry that contains their distinguished name.
	 */
	@ModelNodeBinding(detypedName = "user-dn-attribute")
	public String userDnAttribute() {
		return this.userDnAttribute;
	}

	/**
	 * The attribute on the user entry that contains their distinguished name.
	 */
	@SuppressWarnings("unchecked")
	public T userDnAttribute(String value) {
		Object oldValue = this.userDnAttribute;
		this.userDnAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("userDnAttribute", oldValue, value);
		return (T) this;
	}

	public UsernameFilterUsernameToDnResources subresources() {
		return this.subresources;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCache value) {
		this.subresources.bySearchTimeCache = value;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCacheConsumer consumer) {
		BySearchTimeCache<? extends BySearchTimeCache> child = new BySearchTimeCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.bySearchTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache() {
		BySearchTimeCache<? extends BySearchTimeCache> child = new BySearchTimeCache<>();
		this.subresources.bySearchTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCacheSupplier supplier) {
		this.subresources.bySearchTimeCache = supplier.get();
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCache value) {
		this.subresources.byAccessTimeCache = value;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCacheConsumer consumer) {
		ByAccessTimeCache<? extends ByAccessTimeCache> child = new ByAccessTimeCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.byAccessTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache() {
		ByAccessTimeCache<? extends ByAccessTimeCache> child = new ByAccessTimeCache<>();
		this.subresources.byAccessTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCacheSupplier supplier) {
		this.subresources.byAccessTimeCache = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for UsernameFilterUsernameToDn
	 */
	public static class UsernameFilterUsernameToDnResources {
		private BySearchTimeCache bySearchTimeCache;
		private ByAccessTimeCache byAccessTimeCache;

		/**
		 * A cache to hold the results of previous LDAP interactions.
		 */
		@Subresource
		public BySearchTimeCache bySearchTimeCache() {
			return this.bySearchTimeCache;
		}

		/**
		 * A cache to hold the results of previous LDAP interactions.
		 */
		@Subresource
		public ByAccessTimeCache byAccessTimeCache() {
			return this.byAccessTimeCache;
		}
	}
}