package org.wildfly.swarm.config.messaging.activemq;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorServiceConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorServiceSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorService;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPAcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPAcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPAcceptor;
import org.wildfly.swarm.config.messaging.activemq.server.ClusterConnectionConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ClusterConnectionSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ClusterConnection;
import org.wildfly.swarm.config.messaging.activemq.server.BroadcastGroupConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.BroadcastGroupSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.BroadcastGroup;
import org.wildfly.swarm.config.messaging.activemq.server.RuntimeQueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.RuntimeQueueSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.RuntimeQueue;
import org.wildfly.swarm.config.messaging.activemq.server.AddressSettingConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.AddressSettingSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.AddressSetting;
import org.wildfly.swarm.config.messaging.activemq.server.JMSQueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.JMSQueueSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.JMSQueue;
import org.wildfly.swarm.config.messaging.activemq.server.PooledConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.PooledConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.PooledConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.server.DivertConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.DivertSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Divert;
import org.wildfly.swarm.config.messaging.activemq.server.InVMAcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.InVMAcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.InVMAcceptor;
import org.wildfly.swarm.config.messaging.activemq.server.DiscoveryGroupConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.DiscoveryGroupSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.DiscoveryGroup;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPConnector;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.server.AcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.AcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Acceptor;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteAcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteAcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteAcceptor;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteConnector;
import org.wildfly.swarm.config.messaging.activemq.server.InVMConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.InVMConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.InVMConnector;
import org.wildfly.swarm.config.messaging.activemq.server.LegacyConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.LegacyConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.LegacyConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.server.GroupingHandlerConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.GroupingHandlerSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.GroupingHandler;
import org.wildfly.swarm.config.messaging.activemq.server.JMSTopicConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.JMSTopicSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.JMSTopic;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Connector;
import org.wildfly.swarm.config.messaging.activemq.server.SecuritySettingConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SecuritySettingSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.SecuritySetting;
import org.wildfly.swarm.config.messaging.activemq.server.CoreAddressConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.CoreAddressSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.CoreAddress;
import org.wildfly.swarm.config.messaging.activemq.server.BridgeConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.BridgeSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Bridge;
import org.wildfly.swarm.config.messaging.activemq.server.QueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.QueueSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Queue;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreColocatedHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreColocatedHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreColocatedHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationMasterHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationMasterHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationMasterHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreMasterHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreMasterHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreMasterHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.BindingsDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.BindingsDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.BindingsDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationColocatedHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationColocatedHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationColocatedHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.JournalDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.JournalDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.JournalDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreSlaveHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreSlaveHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreSlaveHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.PagingDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.PagingDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.PagingDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.LargeMessagesDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.LargeMessagesDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.LargeMessagesDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.LiveOnlyHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.LiveOnlyHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.LiveOnlyHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationSlaveHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationSlaveHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationSlaveHAPolicySupplier;
/**
 * An ActiveMQ server instance.
 */
@Address("/subsystem=messaging-activemq/server=*")
@ResourceType("server")
public class Server<T extends Server<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean active;
	private Boolean asyncConnectionExecutionEnabled;
	private Long connectionTtlOverride;
	private Integer idCacheSize;
	private List<java.util.Map> incomingInterceptors;
	private List<java.util.Map> outgoingInterceptors;
	private Integer pageMaxConcurrentIo;
	private Boolean persistDeliveryCountBeforeDelivery;
	private Boolean persistIdCache;
	private Boolean persistenceEnabled;
	private Integer scheduledThreadPoolMaxSize;
	private Boolean started;
	private Integer threadPoolMaxSize;
	private String version;
	private Boolean wildCardRoutingEnabled;
	private String clusterPassword;
	private String clusterUser;
	private Long memoryMeasureInterval;
	private Integer memoryWarningThreshold;
	private Integer perfBlastPages;
	private Boolean runSyncSpeedTest;
	private Long serverDumpInterval;
	private Boolean createBindingsDir;
	private Boolean createJournalDir;
	private Long journalBufferSize;
	private Long journalBufferTimeout;
	private Integer journalCompactMinFiles;
	private Integer journalCompactPercentage;
	private Long journalFileSize;
	private Integer journalMaxIo;
	private Integer journalMinFiles;
	private Boolean journalSyncNonTransactional;
	private Boolean journalSyncTransactional;
	private JournalType journalType;
	private Boolean logJournalWriteRate;
	private String jmxDomain;
	private Boolean jmxManagementEnabled;
	private String managementAddress;
	private String managementNotificationAddress;
	private Long messageExpiryScanPeriod;
	private Integer messageExpiryThreadPriority;
	private Boolean overrideInVmSecurity;
	private String securityDomain;
	private Boolean securityEnabled;
	private Long securityInvalidationInterval;
	private Integer messageCounterMaxDayHistory;
	private Long messageCounterSamplePeriod;
	private Boolean statisticsEnabled;
	private Long transactionTimeout;
	private Long transactionTimeoutScanPeriod;
	private ServerResources subresources = new ServerResources();

	public Server(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Whether the server is active (and accepting connections) or passive (in
	 * backup mode, waiting for failover).
	 */
	@ModelNodeBinding(detypedName = "active")
	public Boolean active() {
		return this.active;
	}

	/**
	 * Whether the server is active (and accepting connections) or passive (in
	 * backup mode, waiting for failover).
	 */
	@SuppressWarnings("unchecked")
	public T active(Boolean value) {
		Object oldValue = this.active;
		this.active = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("active", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether incoming packets on the server should be handed off to a thread
	 * from the thread pool for processing. False if they should be handled on
	 * the remoting thread.
	 */
	@ModelNodeBinding(detypedName = "async-connection-execution-enabled")
	public Boolean asyncConnectionExecutionEnabled() {
		return this.asyncConnectionExecutionEnabled;
	}

	/**
	 * Whether incoming packets on the server should be handed off to a thread
	 * from the thread pool for processing. False if they should be handled on
	 * the remoting thread.
	 */
	@SuppressWarnings("unchecked")
	public T asyncConnectionExecutionEnabled(Boolean value) {
		Object oldValue = this.asyncConnectionExecutionEnabled;
		this.asyncConnectionExecutionEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("asyncConnectionExecutionEnabled",
					oldValue, value);
		return (T) this;
	}

	/**
	 * If set, this will override how long (in ms) to keep a connection alive
	 * without receiving a ping.
	 */
	@ModelNodeBinding(detypedName = "connection-ttl-override")
	public Long connectionTtlOverride() {
		return this.connectionTtlOverride;
	}

	/**
	 * If set, this will override how long (in ms) to keep a connection alive
	 * without receiving a ping.
	 */
	@SuppressWarnings("unchecked")
	public T connectionTtlOverride(Long value) {
		Object oldValue = this.connectionTtlOverride;
		this.connectionTtlOverride = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionTtlOverride", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The size of the cache for pre-creating message IDs.
	 */
	@ModelNodeBinding(detypedName = "id-cache-size")
	public Integer idCacheSize() {
		return this.idCacheSize;
	}

	/**
	 * The size of the cache for pre-creating message IDs.
	 */
	@SuppressWarnings("unchecked")
	public T idCacheSize(Integer value) {
		Object oldValue = this.idCacheSize;
		this.idCacheSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("idCacheSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@ModelNodeBinding(detypedName = "incoming-interceptors")
	public List<Map> incomingInterceptors() {
		return this.incomingInterceptors;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T incomingInterceptors(List<java.util.Map> value) {
		Object oldValue = this.incomingInterceptors;
		this.incomingInterceptors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("incomingInterceptors", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	public T incomingInterceptor(Map value) {
		if (this.incomingInterceptors == null) {
			this.incomingInterceptors = new java.util.ArrayList<>();
		}
		this.incomingInterceptors.add(value);
		return (T) this;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T incomingInterceptors(Map... args) {
		incomingInterceptors(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@ModelNodeBinding(detypedName = "outgoing-interceptors")
	public List<Map> outgoingInterceptors() {
		return this.outgoingInterceptors;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T outgoingInterceptors(List<java.util.Map> value) {
		Object oldValue = this.outgoingInterceptors;
		this.outgoingInterceptors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("outgoingInterceptors", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	public T outgoingInterceptor(Map value) {
		if (this.outgoingInterceptors == null) {
			this.outgoingInterceptors = new java.util.ArrayList<>();
		}
		this.outgoingInterceptors.add(value);
		return (T) this;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T outgoingInterceptors(Map... args) {
		outgoingInterceptors(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The maximum number of concurrent reads allowed on paging
	 */
	@ModelNodeBinding(detypedName = "page-max-concurrent-io")
	public Integer pageMaxConcurrentIo() {
		return this.pageMaxConcurrentIo;
	}

	/**
	 * The maximum number of concurrent reads allowed on paging
	 */
	@SuppressWarnings("unchecked")
	public T pageMaxConcurrentIo(Integer value) {
		Object oldValue = this.pageMaxConcurrentIo;
		this.pageMaxConcurrentIo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("pageMaxConcurrentIo", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the delivery count is persisted before delivery. False means that
	 * this only happens after a message has been cancelled.
	 */
	@ModelNodeBinding(detypedName = "persist-delivery-count-before-delivery")
	public Boolean persistDeliveryCountBeforeDelivery() {
		return this.persistDeliveryCountBeforeDelivery;
	}

	/**
	 * Whether the delivery count is persisted before delivery. False means that
	 * this only happens after a message has been cancelled.
	 */
	@SuppressWarnings("unchecked")
	public T persistDeliveryCountBeforeDelivery(Boolean value) {
		Object oldValue = this.persistDeliveryCountBeforeDelivery;
		this.persistDeliveryCountBeforeDelivery = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("persistDeliveryCountBeforeDelivery",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Whether IDs are persisted to the journal.
	 */
	@ModelNodeBinding(detypedName = "persist-id-cache")
	public Boolean persistIdCache() {
		return this.persistIdCache;
	}

	/**
	 * Whether IDs are persisted to the journal.
	 */
	@SuppressWarnings("unchecked")
	public T persistIdCache(Boolean value) {
		Object oldValue = this.persistIdCache;
		this.persistIdCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("persistIdCache", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the server will use the file based journal for persistence.
	 */
	@ModelNodeBinding(detypedName = "persistence-enabled")
	public Boolean persistenceEnabled() {
		return this.persistenceEnabled;
	}

	/**
	 * Whether the server will use the file based journal for persistence.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceEnabled(Boolean value) {
		Object oldValue = this.persistenceEnabled;
		this.persistenceEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("persistenceEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of threads that the main scheduled thread pool has.
	 */
	@ModelNodeBinding(detypedName = "scheduled-thread-pool-max-size")
	public Integer scheduledThreadPoolMaxSize() {
		return this.scheduledThreadPoolMaxSize;
	}

	/**
	 * The number of threads that the main scheduled thread pool has.
	 */
	@SuppressWarnings("unchecked")
	public T scheduledThreadPoolMaxSize(Integer value) {
		Object oldValue = this.scheduledThreadPoolMaxSize;
		this.scheduledThreadPoolMaxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("scheduledThreadPoolMaxSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Whether this server is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether this server is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(Boolean value) {
		Object oldValue = this.started;
		this.started = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("started", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of threads that the main thread pool has. -1 means no limit.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-max-size")
	public Integer threadPoolMaxSize() {
		return this.threadPoolMaxSize;
	}

	/**
	 * The number of threads that the main thread pool has. -1 means no limit.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolMaxSize(Integer value) {
		Object oldValue = this.threadPoolMaxSize;
		this.threadPoolMaxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("threadPoolMaxSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The server's version.
	 */
	@ModelNodeBinding(detypedName = "version")
	public String version() {
		return this.version;
	}

	/**
	 * The server's version.
	 */
	@SuppressWarnings("unchecked")
	public T version(String value) {
		Object oldValue = this.version;
		this.version = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("version", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the server supports wild card routing.
	 */
	@ModelNodeBinding(detypedName = "wild-card-routing-enabled")
	public Boolean wildCardRoutingEnabled() {
		return this.wildCardRoutingEnabled;
	}

	/**
	 * Whether the server supports wild card routing.
	 */
	@SuppressWarnings("unchecked")
	public T wildCardRoutingEnabled(Boolean value) {
		Object oldValue = this.wildCardRoutingEnabled;
		this.wildCardRoutingEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("wildCardRoutingEnabled", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The password used by cluster connections to communicate between the
	 * clustered nodes.
	 */
	@ModelNodeBinding(detypedName = "cluster-password")
	public String clusterPassword() {
		return this.clusterPassword;
	}

	/**
	 * The password used by cluster connections to communicate between the
	 * clustered nodes.
	 */
	@SuppressWarnings("unchecked")
	public T clusterPassword(String value) {
		Object oldValue = this.clusterPassword;
		this.clusterPassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clusterPassword", oldValue, value);
		return (T) this;
	}

	/**
	 * The user used by cluster connections to communicate between the clustered
	 * nodes.
	 */
	@ModelNodeBinding(detypedName = "cluster-user")
	public String clusterUser() {
		return this.clusterUser;
	}

	/**
	 * The user used by cluster connections to communicate between the clustered
	 * nodes.
	 */
	@SuppressWarnings("unchecked")
	public T clusterUser(String value) {
		Object oldValue = this.clusterUser;
		this.clusterUser = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clusterUser", oldValue, value);
		return (T) this;
	}

	/**
	 * Frequency to sample JVM memory in ms (or -1 to disable memory sampling)
	 */
	@ModelNodeBinding(detypedName = "memory-measure-interval")
	public Long memoryMeasureInterval() {
		return this.memoryMeasureInterval;
	}

	/**
	 * Frequency to sample JVM memory in ms (or -1 to disable memory sampling)
	 */
	@SuppressWarnings("unchecked")
	public T memoryMeasureInterval(Long value) {
		Object oldValue = this.memoryMeasureInterval;
		this.memoryMeasureInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("memoryMeasureInterval", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Percentage of available memory which if exceeded results in a warning log
	 */
	@ModelNodeBinding(detypedName = "memory-warning-threshold")
	public Integer memoryWarningThreshold() {
		return this.memoryWarningThreshold;
	}

	/**
	 * Percentage of available memory which if exceeded results in a warning log
	 */
	@SuppressWarnings("unchecked")
	public T memoryWarningThreshold(Integer value) {
		Object oldValue = this.memoryWarningThreshold;
		this.memoryWarningThreshold = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("memoryWarningThreshold", oldValue,
					value);
		return (T) this;
	}

	/**
	 * TODO
	 */
	@ModelNodeBinding(detypedName = "perf-blast-pages")
	public Integer perfBlastPages() {
		return this.perfBlastPages;
	}

	/**
	 * TODO
	 */
	@SuppressWarnings("unchecked")
	public T perfBlastPages(Integer value) {
		Object oldValue = this.perfBlastPages;
		this.perfBlastPages = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("perfBlastPages", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether on startup to perform a diagnostic test on how fast your disk can
	 * sync. Useful when determining performance issues.
	 */
	@ModelNodeBinding(detypedName = "run-sync-speed-test")
	public Boolean runSyncSpeedTest() {
		return this.runSyncSpeedTest;
	}

	/**
	 * Whether on startup to perform a diagnostic test on how fast your disk can
	 * sync. Useful when determining performance issues.
	 */
	@SuppressWarnings("unchecked")
	public T runSyncSpeedTest(Boolean value) {
		Object oldValue = this.runSyncSpeedTest;
		this.runSyncSpeedTest = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("runSyncSpeedTest", oldValue, value);
		return (T) this;
	}

	/**
	 * How often to dump basic runtime information to the server log. A value
	 * less than 1 disables this feature.
	 */
	@ModelNodeBinding(detypedName = "server-dump-interval")
	public Long serverDumpInterval() {
		return this.serverDumpInterval;
	}

	/**
	 * How often to dump basic runtime information to the server log. A value
	 * less than 1 disables this feature.
	 */
	@SuppressWarnings("unchecked")
	public T serverDumpInterval(Long value) {
		Object oldValue = this.serverDumpInterval;
		this.serverDumpInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverDumpInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the server should create the bindings directory on start up.
	 */
	@ModelNodeBinding(detypedName = "create-bindings-dir")
	public Boolean createBindingsDir() {
		return this.createBindingsDir;
	}

	/**
	 * Whether the server should create the bindings directory on start up.
	 */
	@SuppressWarnings("unchecked")
	public T createBindingsDir(Boolean value) {
		Object oldValue = this.createBindingsDir;
		this.createBindingsDir = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("createBindingsDir", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the server should create the journal directory on start up.
	 */
	@ModelNodeBinding(detypedName = "create-journal-dir")
	public Boolean createJournalDir() {
		return this.createJournalDir;
	}

	/**
	 * Whether the server should create the journal directory on start up.
	 */
	@SuppressWarnings("unchecked")
	public T createJournalDir(Boolean value) {
		Object oldValue = this.createJournalDir;
		this.createJournalDir = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("createJournalDir", oldValue, value);
		return (T) this;
	}

	/**
	 * The size of the internal buffer on the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-buffer-size")
	public Long journalBufferSize() {
		return this.journalBufferSize;
	}

	/**
	 * The size of the internal buffer on the journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalBufferSize(Long value) {
		Object oldValue = this.journalBufferSize;
		this.journalBufferSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalBufferSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The timeout (in nanoseconds) used to flush internal buffers on the
	 * journal.
	 */
	@ModelNodeBinding(detypedName = "journal-buffer-timeout")
	public Long journalBufferTimeout() {
		return this.journalBufferTimeout;
	}

	/**
	 * The timeout (in nanoseconds) used to flush internal buffers on the
	 * journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalBufferTimeout(Long value) {
		Object oldValue = this.journalBufferTimeout;
		this.journalBufferTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalBufferTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The minimal number of journal data files before we can start compacting.
	 */
	@ModelNodeBinding(detypedName = "journal-compact-min-files")
	public Integer journalCompactMinFiles() {
		return this.journalCompactMinFiles;
	}

	/**
	 * The minimal number of journal data files before we can start compacting.
	 */
	@SuppressWarnings("unchecked")
	public T journalCompactMinFiles(Integer value) {
		Object oldValue = this.journalCompactMinFiles;
		this.journalCompactMinFiles = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalCompactMinFiles", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The percentage of live data on which we consider compacting the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-compact-percentage")
	public Integer journalCompactPercentage() {
		return this.journalCompactPercentage;
	}

	/**
	 * The percentage of live data on which we consider compacting the journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalCompactPercentage(Integer value) {
		Object oldValue = this.journalCompactPercentage;
		this.journalCompactPercentage = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalCompactPercentage", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The size (in bytes) of each journal file.
	 */
	@ModelNodeBinding(detypedName = "journal-file-size")
	public Long journalFileSize() {
		return this.journalFileSize;
	}

	/**
	 * The size (in bytes) of each journal file.
	 */
	@SuppressWarnings("unchecked")
	public T journalFileSize(Long value) {
		Object oldValue = this.journalFileSize;
		this.journalFileSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalFileSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of write requests that can be in the AIO queue at any
	 * one time.
	 */
	@ModelNodeBinding(detypedName = "journal-max-io")
	public Integer journalMaxIo() {
		return this.journalMaxIo;
	}

	/**
	 * The maximum number of write requests that can be in the AIO queue at any
	 * one time.
	 */
	@SuppressWarnings("unchecked")
	public T journalMaxIo(Integer value) {
		Object oldValue = this.journalMaxIo;
		this.journalMaxIo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalMaxIo", oldValue, value);
		return (T) this;
	}

	/**
	 * How many journal files to pre-create.
	 */
	@ModelNodeBinding(detypedName = "journal-min-files")
	public Integer journalMinFiles() {
		return this.journalMinFiles;
	}

	/**
	 * How many journal files to pre-create.
	 */
	@SuppressWarnings("unchecked")
	public T journalMinFiles(Integer value) {
		Object oldValue = this.journalMinFiles;
		this.journalMinFiles = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalMinFiles", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to wait for non transaction data to be synced to the journal
	 * before returning a response to the client.
	 */
	@ModelNodeBinding(detypedName = "journal-sync-non-transactional")
	public Boolean journalSyncNonTransactional() {
		return this.journalSyncNonTransactional;
	}

	/**
	 * Whether to wait for non transaction data to be synced to the journal
	 * before returning a response to the client.
	 */
	@SuppressWarnings("unchecked")
	public T journalSyncNonTransactional(Boolean value) {
		Object oldValue = this.journalSyncNonTransactional;
		this.journalSyncNonTransactional = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalSyncNonTransactional",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to wait for transaction data to be synchronized to the journal
	 * before returning a response to the client.
	 */
	@ModelNodeBinding(detypedName = "journal-sync-transactional")
	public Boolean journalSyncTransactional() {
		return this.journalSyncTransactional;
	}

	/**
	 * Whether to wait for transaction data to be synchronized to the journal
	 * before returning a response to the client.
	 */
	@SuppressWarnings("unchecked")
	public T journalSyncTransactional(Boolean value) {
		Object oldValue = this.journalSyncTransactional;
		this.journalSyncTransactional = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalSyncTransactional", oldValue,
					value);
		return (T) this;
	}

	@Deprecated
	@SuppressWarnings("unchecked")
	public T journalType(final String journalType) {
		if (journalType == null) {
			this.journalType = null;
		} else {
			boolean found = false;
			for (JournalType e : JournalType.values()) {
				if (e.toString().equals(journalType)) {
					journalType(e);
					found = true;
					break;
				}
			}
			if (!found)
				throw new RuntimeException(String.format(
						"Value '%s' not valid. Valid values are: %s",
						journalType, Arrays.asList(JournalType.values())));
		}
		return (T) this;
	}

	/**
	 * The type of journal to use.
	 */
	@ModelNodeBinding(detypedName = "journal-type")
	public JournalType journalType() {
		return this.journalType;
	}

	/**
	 * The type of journal to use.
	 */
	@SuppressWarnings("unchecked")
	public T journalType(JournalType value) {
		Object oldValue = this.journalType;
		this.journalType = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalType", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to periodically log the journal's write rate and flush rate.
	 */
	@ModelNodeBinding(detypedName = "log-journal-write-rate")
	public Boolean logJournalWriteRate() {
		return this.logJournalWriteRate;
	}

	/**
	 * Whether to periodically log the journal's write rate and flush rate.
	 */
	@SuppressWarnings("unchecked")
	public T logJournalWriteRate(Boolean value) {
		Object oldValue = this.logJournalWriteRate;
		this.logJournalWriteRate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("logJournalWriteRate", oldValue, value);
		return (T) this;
	}

	/**
	 * The JMX domain used to register internal ActiveMQ MBeans in the
	 * MBeanServer.
	 */
	@ModelNodeBinding(detypedName = "jmx-domain")
	public String jmxDomain() {
		return this.jmxDomain;
	}

	/**
	 * The JMX domain used to register internal ActiveMQ MBeans in the
	 * MBeanServer.
	 */
	@SuppressWarnings("unchecked")
	public T jmxDomain(String value) {
		Object oldValue = this.jmxDomain;
		this.jmxDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jmxDomain", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether ActiveMQ should expose its internal management API via JMX. This
	 * is not recommended, as accessing these MBeans can lead to inconsistent
	 * configuration.
	 */
	@ModelNodeBinding(detypedName = "jmx-management-enabled")
	public Boolean jmxManagementEnabled() {
		return this.jmxManagementEnabled;
	}

	/**
	 * Whether ActiveMQ should expose its internal management API via JMX. This
	 * is not recommended, as accessing these MBeans can lead to inconsistent
	 * configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jmxManagementEnabled(Boolean value) {
		Object oldValue = this.jmxManagementEnabled;
		this.jmxManagementEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jmxManagementEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Address to send management messages to.
	 */
	@ModelNodeBinding(detypedName = "management-address")
	public String managementAddress() {
		return this.managementAddress;
	}

	/**
	 * Address to send management messages to.
	 */
	@SuppressWarnings("unchecked")
	public T managementAddress(String value) {
		Object oldValue = this.managementAddress;
		this.managementAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("managementAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the address that consumers bind to to receive management
	 * notifications.
	 */
	@ModelNodeBinding(detypedName = "management-notification-address")
	public String managementNotificationAddress() {
		return this.managementNotificationAddress;
	}

	/**
	 * The name of the address that consumers bind to to receive management
	 * notifications.
	 */
	@SuppressWarnings("unchecked")
	public T managementNotificationAddress(String value) {
		Object oldValue = this.managementNotificationAddress;
		this.managementNotificationAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("managementNotificationAddress",
					oldValue, value);
		return (T) this;
	}

	/**
	 * How often (in ms) to scan for expired messages.
	 */
	@ModelNodeBinding(detypedName = "message-expiry-scan-period")
	public Long messageExpiryScanPeriod() {
		return this.messageExpiryScanPeriod;
	}

	/**
	 * How often (in ms) to scan for expired messages.
	 */
	@SuppressWarnings("unchecked")
	public T messageExpiryScanPeriod(Long value) {
		Object oldValue = this.messageExpiryScanPeriod;
		this.messageExpiryScanPeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageExpiryScanPeriod", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The priority of the thread expiring messages.
	 */
	@ModelNodeBinding(detypedName = "message-expiry-thread-priority")
	public Integer messageExpiryThreadPriority() {
		return this.messageExpiryThreadPriority;
	}

	/**
	 * The priority of the thread expiring messages.
	 */
	@SuppressWarnings("unchecked")
	public T messageExpiryThreadPriority(Integer value) {
		Object oldValue = this.messageExpiryThreadPriority;
		this.messageExpiryThreadPriority = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageExpiryThreadPriority",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the ActiveMQ server will override security credentials for in-vm
	 * connections.
	 */
	@ModelNodeBinding(detypedName = "override-in-vm-security")
	public Boolean overrideInVmSecurity() {
		return this.overrideInVmSecurity;
	}

	/**
	 * Whether the ActiveMQ server will override security credentials for in-vm
	 * connections.
	 */
	@SuppressWarnings("unchecked")
	public T overrideInVmSecurity(Boolean value) {
		Object oldValue = this.overrideInVmSecurity;
		this.overrideInVmSecurity = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("overrideInVmSecurity", oldValue, value);
		return (T) this;
	}

	/**
	 * The security domain to use to verify user and role information
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * The security domain to use to verify user and role information
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(String value) {
		Object oldValue = this.securityDomain;
		this.securityDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityDomain", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether security is enabled.
	 */
	@ModelNodeBinding(detypedName = "security-enabled")
	public Boolean securityEnabled() {
		return this.securityEnabled;
	}

	/**
	 * Whether security is enabled.
	 */
	@SuppressWarnings("unchecked")
	public T securityEnabled(Boolean value) {
		Object oldValue = this.securityEnabled;
		this.securityEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * How long (in ms) to wait before invalidating the security cache.
	 */
	@ModelNodeBinding(detypedName = "security-invalidation-interval")
	public Long securityInvalidationInterval() {
		return this.securityInvalidationInterval;
	}

	/**
	 * How long (in ms) to wait before invalidating the security cache.
	 */
	@SuppressWarnings("unchecked")
	public T securityInvalidationInterval(Long value) {
		Object oldValue = this.securityInvalidationInterval;
		this.securityInvalidationInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityInvalidationInterval",
					oldValue, value);
		return (T) this;
	}

	/**
	 * How many days to keep message counter history.
	 */
	@ModelNodeBinding(detypedName = "message-counter-max-day-history")
	public Integer messageCounterMaxDayHistory() {
		return this.messageCounterMaxDayHistory;
	}

	/**
	 * How many days to keep message counter history.
	 */
	@SuppressWarnings("unchecked")
	public T messageCounterMaxDayHistory(Integer value) {
		Object oldValue = this.messageCounterMaxDayHistory;
		this.messageCounterMaxDayHistory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageCounterMaxDayHistory",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The sample period (in ms) to use for message counters.
	 */
	@ModelNodeBinding(detypedName = "message-counter-sample-period")
	public Long messageCounterSamplePeriod() {
		return this.messageCounterSamplePeriod;
	}

	/**
	 * The sample period (in ms) to use for message counters.
	 */
	@SuppressWarnings("unchecked")
	public T messageCounterSamplePeriod(Long value) {
		Object oldValue = this.messageCounterSamplePeriod;
		this.messageCounterSamplePeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageCounterSamplePeriod", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Whether gathering of statistics such as message counters are enabled.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Whether gathering of statistics such as message counters are enabled.
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * How long (in ms) before a transaction can be removed from the resource
	 * manager after create time.
	 */
	@ModelNodeBinding(detypedName = "transaction-timeout")
	public Long transactionTimeout() {
		return this.transactionTimeout;
	}

	/**
	 * How long (in ms) before a transaction can be removed from the resource
	 * manager after create time.
	 */
	@SuppressWarnings("unchecked")
	public T transactionTimeout(Long value) {
		Object oldValue = this.transactionTimeout;
		this.transactionTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transactionTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * How often (in ms) to scan for timeout transactions.
	 */
	@ModelNodeBinding(detypedName = "transaction-timeout-scan-period")
	public Long transactionTimeoutScanPeriod() {
		return this.transactionTimeoutScanPeriod;
	}

	/**
	 * How often (in ms) to scan for timeout transactions.
	 */
	@SuppressWarnings("unchecked")
	public T transactionTimeoutScanPeriod(Long value) {
		Object oldValue = this.transactionTimeoutScanPeriod;
		this.transactionTimeoutScanPeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transactionTimeoutScanPeriod",
					oldValue, value);
		return (T) this;
	}

	public ServerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ConnectorService objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConnectorService objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectorServices(List<ConnectorService> value) {
		this.subresources.connectorServices = value;
		return (T) this;
	}

	/**
	 * Add the ConnectorService object to the list of subresources
	 * 
	 * @param value
	 *            The ConnectorService to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(ConnectorService value) {
		this.subresources.connectorServices.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectorService object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectorService resource
	 * @param config
	 *            The ConnectorServiceConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(String childKey, ConnectorServiceConsumer consumer) {
		ConnectorService<? extends ConnectorService> child = new ConnectorService<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		connectorService(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectorService object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectorService resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(String childKey) {
		connectorService(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConnectorService object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(ConnectorServiceSupplier supplier) {
		connectorService(supplier.get());
		return (T) this;
	}

	/**
	 * Add all HTTPAcceptor objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of HTTPAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptors(List<HTTPAcceptor> value) {
		this.subresources.httpAcceptors = value;
		return (T) this;
	}

	/**
	 * Add the HTTPAcceptor object to the list of subresources
	 * 
	 * @param value
	 *            The HTTPAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(HTTPAcceptor value) {
		this.subresources.httpAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPAcceptor resource
	 * @param config
	 *            The HTTPAcceptorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(String childKey, HTTPAcceptorConsumer consumer) {
		HTTPAcceptor<? extends HTTPAcceptor> child = new HTTPAcceptor<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		httpAcceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPAcceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(String childKey) {
		httpAcceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied HTTPAcceptor object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(HTTPAcceptorSupplier supplier) {
		httpAcceptor(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ClusterConnection objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ClusterConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnections(List<ClusterConnection> value) {
		this.subresources.clusterConnections = value;
		return (T) this;
	}

	/**
	 * Add the ClusterConnection object to the list of subresources
	 * 
	 * @param value
	 *            The ClusterConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(ClusterConnection value) {
		this.subresources.clusterConnections.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ClusterConnection object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ClusterConnection resource
	 * @param config
	 *            The ClusterConnectionConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(String childKey,
			ClusterConnectionConsumer consumer) {
		ClusterConnection<? extends ClusterConnection> child = new ClusterConnection<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		clusterConnection(child);
		return (T) this;
	}

	/**
	 * Create and configure a ClusterConnection object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ClusterConnection resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(String childKey) {
		clusterConnection(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ClusterConnection object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(ClusterConnectionSupplier supplier) {
		clusterConnection(supplier.get());
		return (T) this;
	}

	/**
	 * Add all BroadcastGroup objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of BroadcastGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroups(List<BroadcastGroup> value) {
		this.subresources.broadcastGroups = value;
		return (T) this;
	}

	/**
	 * Add the BroadcastGroup object to the list of subresources
	 * 
	 * @param value
	 *            The BroadcastGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(BroadcastGroup value) {
		this.subresources.broadcastGroups.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a BroadcastGroup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the BroadcastGroup resource
	 * @param config
	 *            The BroadcastGroupConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(String childKey, BroadcastGroupConsumer consumer) {
		BroadcastGroup<? extends BroadcastGroup> child = new BroadcastGroup<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		broadcastGroup(child);
		return (T) this;
	}

	/**
	 * Create and configure a BroadcastGroup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the BroadcastGroup resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(String childKey) {
		broadcastGroup(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied BroadcastGroup object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(BroadcastGroupSupplier supplier) {
		broadcastGroup(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RuntimeQueue objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RuntimeQueue objects.
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueues(List<RuntimeQueue> value) {
		this.subresources.runtimeQueues = value;
		return (T) this;
	}

	/**
	 * Add the RuntimeQueue object to the list of subresources
	 * 
	 * @param value
	 *            The RuntimeQueue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(RuntimeQueue value) {
		this.subresources.runtimeQueues.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RuntimeQueue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RuntimeQueue resource
	 * @param config
	 *            The RuntimeQueueConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(String childKey, RuntimeQueueConsumer consumer) {
		RuntimeQueue<? extends RuntimeQueue> child = new RuntimeQueue<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		runtimeQueue(child);
		return (T) this;
	}

	/**
	 * Create and configure a RuntimeQueue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RuntimeQueue resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(String childKey) {
		runtimeQueue(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RuntimeQueue object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(RuntimeQueueSupplier supplier) {
		runtimeQueue(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AddressSetting objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AddressSetting objects.
	 */
	@SuppressWarnings("unchecked")
	public T addressSettings(List<AddressSetting> value) {
		this.subresources.addressSettings = value;
		return (T) this;
	}

	/**
	 * Add the AddressSetting object to the list of subresources
	 * 
	 * @param value
	 *            The AddressSetting to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(AddressSetting value) {
		this.subresources.addressSettings.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AddressSetting object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AddressSetting resource
	 * @param config
	 *            The AddressSettingConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(String childKey, AddressSettingConsumer consumer) {
		AddressSetting<? extends AddressSetting> child = new AddressSetting<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		addressSetting(child);
		return (T) this;
	}

	/**
	 * Create and configure a AddressSetting object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AddressSetting resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(String childKey) {
		addressSetting(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AddressSetting object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(AddressSettingSupplier supplier) {
		addressSetting(supplier.get());
		return (T) this;
	}

	/**
	 * Add all JMSQueue objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of JMSQueue objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueues(List<JMSQueue> value) {
		this.subresources.jmsQueues = value;
		return (T) this;
	}

	/**
	 * Add the JMSQueue object to the list of subresources
	 * 
	 * @param value
	 *            The JMSQueue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(JMSQueue value) {
		this.subresources.jmsQueues.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a JMSQueue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JMSQueue resource
	 * @param config
	 *            The JMSQueueConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(String childKey, JMSQueueConsumer consumer) {
		JMSQueue<? extends JMSQueue> child = new JMSQueue<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		jmsQueue(child);
		return (T) this;
	}

	/**
	 * Create and configure a JMSQueue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JMSQueue resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(String childKey) {
		jmsQueue(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied JMSQueue object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(JMSQueueSupplier supplier) {
		jmsQueue(supplier.get());
		return (T) this;
	}

	/**
	 * Add all PooledConnectionFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PooledConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactories(List<PooledConnectionFactory> value) {
		this.subresources.pooledConnectionFactories = value;
		return (T) this;
	}

	/**
	 * Add the PooledConnectionFactory object to the list of subresources
	 * 
	 * @param value
	 *            The PooledConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(PooledConnectionFactory value) {
		this.subresources.pooledConnectionFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PooledConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PooledConnectionFactory resource
	 * @param config
	 *            The PooledConnectionFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(String childKey,
			PooledConnectionFactoryConsumer consumer) {
		PooledConnectionFactory<? extends PooledConnectionFactory> child = new PooledConnectionFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		pooledConnectionFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a PooledConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PooledConnectionFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(String childKey) {
		pooledConnectionFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PooledConnectionFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(PooledConnectionFactorySupplier supplier) {
		pooledConnectionFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Divert objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Divert objects.
	 */
	@SuppressWarnings("unchecked")
	public T diverts(List<Divert> value) {
		this.subresources.diverts = value;
		return (T) this;
	}

	/**
	 * Add the Divert object to the list of subresources
	 * 
	 * @param value
	 *            The Divert to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T divert(Divert value) {
		this.subresources.diverts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Divert object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Divert resource
	 * @param config
	 *            The DivertConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T divert(String childKey, DivertConsumer consumer) {
		Divert<? extends Divert> child = new Divert<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		divert(child);
		return (T) this;
	}

	/**
	 * Create and configure a Divert object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Divert resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T divert(String childKey) {
		divert(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Divert object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T divert(DivertSupplier supplier) {
		divert(supplier.get());
		return (T) this;
	}

	/**
	 * Add all InVMAcceptor objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of InVMAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptors(List<InVMAcceptor> value) {
		this.subresources.inVmAcceptors = value;
		return (T) this;
	}

	/**
	 * Add the InVMAcceptor object to the list of subresources
	 * 
	 * @param value
	 *            The InVMAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(InVMAcceptor value) {
		this.subresources.inVmAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a InVMAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the InVMAcceptor resource
	 * @param config
	 *            The InVMAcceptorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(String childKey, InVMAcceptorConsumer consumer) {
		InVMAcceptor<? extends InVMAcceptor> child = new InVMAcceptor<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		inVmAcceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a InVMAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the InVMAcceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(String childKey) {
		inVmAcceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied InVMAcceptor object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(InVMAcceptorSupplier supplier) {
		inVmAcceptor(supplier.get());
		return (T) this;
	}

	/**
	 * Add all DiscoveryGroup objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of DiscoveryGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroups(List<DiscoveryGroup> value) {
		this.subresources.discoveryGroups = value;
		return (T) this;
	}

	/**
	 * Add the DiscoveryGroup object to the list of subresources
	 * 
	 * @param value
	 *            The DiscoveryGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(DiscoveryGroup value) {
		this.subresources.discoveryGroups.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a DiscoveryGroup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the DiscoveryGroup resource
	 * @param config
	 *            The DiscoveryGroupConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(String childKey, DiscoveryGroupConsumer consumer) {
		DiscoveryGroup<? extends DiscoveryGroup> child = new DiscoveryGroup<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		discoveryGroup(child);
		return (T) this;
	}

	/**
	 * Create and configure a DiscoveryGroup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the DiscoveryGroup resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(String childKey) {
		discoveryGroup(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied DiscoveryGroup object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(DiscoveryGroupSupplier supplier) {
		discoveryGroup(supplier.get());
		return (T) this;
	}

	/**
	 * Add all HTTPConnector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of HTTPConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpConnectors(List<HTTPConnector> value) {
		this.subresources.httpConnectors = value;
		return (T) this;
	}

	/**
	 * Add the HTTPConnector object to the list of subresources
	 * 
	 * @param value
	 *            The HTTPConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HTTPConnector value) {
		this.subresources.httpConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPConnector resource
	 * @param config
	 *            The HTTPConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(String childKey, HTTPConnectorConsumer consumer) {
		HTTPConnector<? extends HTTPConnector> child = new HTTPConnector<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		httpConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(String childKey) {
		httpConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied HTTPConnector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HTTPConnectorSupplier supplier) {
		httpConnector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConnectionFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactories(List<ConnectionFactory> value) {
		this.subresources.connectionFactories = value;
		return (T) this;
	}

	/**
	 * Add the ConnectionFactory object to the list of subresources
	 * 
	 * @param value
	 *            The ConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(ConnectionFactory value) {
		this.subresources.connectionFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectionFactory resource
	 * @param config
	 *            The ConnectionFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(String childKey,
			ConnectionFactoryConsumer consumer) {
		ConnectionFactory<? extends ConnectionFactory> child = new ConnectionFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		connectionFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectionFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(String childKey) {
		connectionFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConnectionFactory object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(ConnectionFactorySupplier supplier) {
		connectionFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Acceptor objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Acceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T acceptors(List<Acceptor> value) {
		this.subresources.acceptors = value;
		return (T) this;
	}

	/**
	 * Add the Acceptor object to the list of subresources
	 * 
	 * @param value
	 *            The Acceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(Acceptor value) {
		this.subresources.acceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Acceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Acceptor resource
	 * @param config
	 *            The AcceptorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(String childKey, AcceptorConsumer consumer) {
		Acceptor<? extends Acceptor> child = new Acceptor<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		acceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a Acceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Acceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(String childKey) {
		acceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Acceptor object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(AcceptorSupplier supplier) {
		acceptor(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RemoteAcceptor objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RemoteAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptors(List<RemoteAcceptor> value) {
		this.subresources.remoteAcceptors = value;
		return (T) this;
	}

	/**
	 * Add the RemoteAcceptor object to the list of subresources
	 * 
	 * @param value
	 *            The RemoteAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(RemoteAcceptor value) {
		this.subresources.remoteAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteAcceptor resource
	 * @param config
	 *            The RemoteAcceptorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(String childKey, RemoteAcceptorConsumer consumer) {
		RemoteAcceptor<? extends RemoteAcceptor> child = new RemoteAcceptor<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		remoteAcceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteAcceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(String childKey) {
		remoteAcceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RemoteAcceptor object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(RemoteAcceptorSupplier supplier) {
		remoteAcceptor(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RemoteConnector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RemoteConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnectors(List<RemoteConnector> value) {
		this.subresources.remoteConnectors = value;
		return (T) this;
	}

	/**
	 * Add the RemoteConnector object to the list of subresources
	 * 
	 * @param value
	 *            The RemoteConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(RemoteConnector value) {
		this.subresources.remoteConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteConnector resource
	 * @param config
	 *            The RemoteConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(String childKey, RemoteConnectorConsumer consumer) {
		RemoteConnector<? extends RemoteConnector> child = new RemoteConnector<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		remoteConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(String childKey) {
		remoteConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RemoteConnector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(RemoteConnectorSupplier supplier) {
		remoteConnector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all InVMConnector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of InVMConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnectors(List<InVMConnector> value) {
		this.subresources.inVmConnectors = value;
		return (T) this;
	}

	/**
	 * Add the InVMConnector object to the list of subresources
	 * 
	 * @param value
	 *            The InVMConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(InVMConnector value) {
		this.subresources.inVmConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a InVMConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the InVMConnector resource
	 * @param config
	 *            The InVMConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(String childKey, InVMConnectorConsumer consumer) {
		InVMConnector<? extends InVMConnector> child = new InVMConnector<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		inVmConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a InVMConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the InVMConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(String childKey) {
		inVmConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied InVMConnector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(InVMConnectorSupplier supplier) {
		inVmConnector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LegacyConnectionFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LegacyConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactories(List<LegacyConnectionFactory> value) {
		this.subresources.legacyConnectionFactories = value;
		return (T) this;
	}

	/**
	 * Add the LegacyConnectionFactory object to the list of subresources
	 * 
	 * @param value
	 *            The LegacyConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(LegacyConnectionFactory value) {
		this.subresources.legacyConnectionFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LegacyConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LegacyConnectionFactory resource
	 * @param config
	 *            The LegacyConnectionFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(String childKey,
			LegacyConnectionFactoryConsumer consumer) {
		LegacyConnectionFactory<? extends LegacyConnectionFactory> child = new LegacyConnectionFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		legacyConnectionFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a LegacyConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LegacyConnectionFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(String childKey) {
		legacyConnectionFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LegacyConnectionFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(LegacyConnectionFactorySupplier supplier) {
		legacyConnectionFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all GroupingHandler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of GroupingHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandlers(List<GroupingHandler> value) {
		this.subresources.groupingHandlers = value;
		return (T) this;
	}

	/**
	 * Add the GroupingHandler object to the list of subresources
	 * 
	 * @param value
	 *            The GroupingHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(GroupingHandler value) {
		this.subresources.groupingHandlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a GroupingHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the GroupingHandler resource
	 * @param config
	 *            The GroupingHandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(String childKey, GroupingHandlerConsumer consumer) {
		GroupingHandler<? extends GroupingHandler> child = new GroupingHandler<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		groupingHandler(child);
		return (T) this;
	}

	/**
	 * Create and configure a GroupingHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the GroupingHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(String childKey) {
		groupingHandler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied GroupingHandler object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(GroupingHandlerSupplier supplier) {
		groupingHandler(supplier.get());
		return (T) this;
	}

	/**
	 * Add all JMSTopic objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of JMSTopic objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopics(List<JMSTopic> value) {
		this.subresources.jmsTopics = value;
		return (T) this;
	}

	/**
	 * Add the JMSTopic object to the list of subresources
	 * 
	 * @param value
	 *            The JMSTopic to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(JMSTopic value) {
		this.subresources.jmsTopics.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a JMSTopic object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JMSTopic resource
	 * @param config
	 *            The JMSTopicConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(String childKey, JMSTopicConsumer consumer) {
		JMSTopic<? extends JMSTopic> child = new JMSTopic<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		jmsTopic(child);
		return (T) this;
	}

	/**
	 * Create and configure a JMSTopic object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JMSTopic resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(String childKey) {
		jmsTopic(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied JMSTopic object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(JMSTopicSupplier supplier) {
		jmsTopic(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Connector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Connector objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(List<Connector> value) {
		this.subresources.connectors = value;
		return (T) this;
	}

	/**
	 * Add the Connector object to the list of subresources
	 * 
	 * @param value
	 *            The Connector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(Connector value) {
		this.subresources.connectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Connector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Connector resource
	 * @param config
	 *            The ConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(String childKey, ConnectorConsumer consumer) {
		Connector<? extends Connector> child = new Connector<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		connector(child);
		return (T) this;
	}

	/**
	 * Create and configure a Connector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Connector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(String childKey) {
		connector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Connector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T connector(ConnectorSupplier supplier) {
		connector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all SecuritySetting objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SecuritySetting objects.
	 */
	@SuppressWarnings("unchecked")
	public T securitySettings(List<SecuritySetting> value) {
		this.subresources.securitySettings = value;
		return (T) this;
	}

	/**
	 * Add the SecuritySetting object to the list of subresources
	 * 
	 * @param value
	 *            The SecuritySetting to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(SecuritySetting value) {
		this.subresources.securitySettings.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SecuritySetting object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SecuritySetting resource
	 * @param config
	 *            The SecuritySettingConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(String childKey, SecuritySettingConsumer consumer) {
		SecuritySetting<? extends SecuritySetting> child = new SecuritySetting<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		securitySetting(child);
		return (T) this;
	}

	/**
	 * Create and configure a SecuritySetting object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SecuritySetting resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(String childKey) {
		securitySetting(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SecuritySetting object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(SecuritySettingSupplier supplier) {
		securitySetting(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CoreAddress objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CoreAddress objects.
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(List<CoreAddress> value) {
		this.subresources.coreAddress = value;
		return (T) this;
	}

	/**
	 * Add the CoreAddress object to the list of subresources
	 * 
	 * @param value
	 *            The CoreAddress to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(CoreAddress value) {
		this.subresources.coreAddress.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CoreAddress object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CoreAddress resource
	 * @param config
	 *            The CoreAddressConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(String childKey, CoreAddressConsumer consumer) {
		CoreAddress<? extends CoreAddress> child = new CoreAddress<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		coreAddress(child);
		return (T) this;
	}

	/**
	 * Create and configure a CoreAddress object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CoreAddress resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(String childKey) {
		coreAddress(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CoreAddress object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(CoreAddressSupplier supplier) {
		coreAddress(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Bridge objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Bridge objects.
	 */
	@SuppressWarnings("unchecked")
	public T bridges(List<Bridge> value) {
		this.subresources.bridges = value;
		return (T) this;
	}

	/**
	 * Add the Bridge object to the list of subresources
	 * 
	 * @param value
	 *            The Bridge to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bridge(Bridge value) {
		this.subresources.bridges.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Bridge object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Bridge resource
	 * @param config
	 *            The BridgeConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bridge(String childKey, BridgeConsumer consumer) {
		Bridge<? extends Bridge> child = new Bridge<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		bridge(child);
		return (T) this;
	}

	/**
	 * Create and configure a Bridge object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Bridge resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bridge(String childKey) {
		bridge(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Bridge object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T bridge(BridgeSupplier supplier) {
		bridge(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Queue objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Queue objects.
	 */
	@SuppressWarnings("unchecked")
	public T queues(List<Queue> value) {
		this.subresources.queues = value;
		return (T) this;
	}

	/**
	 * Add the Queue object to the list of subresources
	 * 
	 * @param value
	 *            The Queue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T queue(Queue value) {
		this.subresources.queues.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Queue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Queue resource
	 * @param config
	 *            The QueueConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T queue(String childKey, QueueConsumer consumer) {
		Queue<? extends Queue> child = new Queue<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		queue(child);
		return (T) this;
	}

	/**
	 * Create and configure a Queue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Queue resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T queue(String childKey) {
		queue(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Queue object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T queue(QueueSupplier supplier) {
		queue(supplier.get());
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreColocatedHaPolicy(SharedStoreColocatedHAPolicy value) {
		this.subresources.sharedStoreColocatedHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreColocatedHaPolicy(
			SharedStoreColocatedHAPolicyConsumer consumer) {
		SharedStoreColocatedHAPolicy<? extends SharedStoreColocatedHAPolicy> child = new SharedStoreColocatedHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.sharedStoreColocatedHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreColocatedHaPolicy() {
		SharedStoreColocatedHAPolicy<? extends SharedStoreColocatedHAPolicy> child = new SharedStoreColocatedHAPolicy<>();
		this.subresources.sharedStoreColocatedHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreColocatedHaPolicy(
			SharedStoreColocatedHAPolicySupplier supplier) {
		this.subresources.sharedStoreColocatedHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationMasterHaPolicy(ReplicationMasterHAPolicy value) {
		this.subresources.replicationMasterHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationMasterHaPolicy(
			ReplicationMasterHAPolicyConsumer consumer) {
		ReplicationMasterHAPolicy<? extends ReplicationMasterHAPolicy> child = new ReplicationMasterHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.replicationMasterHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationMasterHaPolicy() {
		ReplicationMasterHAPolicy<? extends ReplicationMasterHAPolicy> child = new ReplicationMasterHAPolicy<>();
		this.subresources.replicationMasterHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationMasterHaPolicy(
			ReplicationMasterHAPolicySupplier supplier) {
		this.subresources.replicationMasterHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreMasterHaPolicy(SharedStoreMasterHAPolicy value) {
		this.subresources.sharedStoreMasterHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreMasterHaPolicy(
			SharedStoreMasterHAPolicyConsumer consumer) {
		SharedStoreMasterHAPolicy<? extends SharedStoreMasterHAPolicy> child = new SharedStoreMasterHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.sharedStoreMasterHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreMasterHaPolicy() {
		SharedStoreMasterHAPolicy<? extends SharedStoreMasterHAPolicy> child = new SharedStoreMasterHAPolicy<>();
		this.subresources.sharedStoreMasterHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreMasterHaPolicy(
			SharedStoreMasterHAPolicySupplier supplier) {
		this.subresources.sharedStoreMasterHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T bindingsDirectoryPath(BindingsDirectoryPath value) {
		this.subresources.bindingsDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T bindingsDirectoryPath(BindingsDirectoryPathConsumer consumer) {
		BindingsDirectoryPath<? extends BindingsDirectoryPath> child = new BindingsDirectoryPath<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.bindingsDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T bindingsDirectoryPath() {
		BindingsDirectoryPath<? extends BindingsDirectoryPath> child = new BindingsDirectoryPath<>();
		this.subresources.bindingsDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T bindingsDirectoryPath(BindingsDirectoryPathSupplier supplier) {
		this.subresources.bindingsDirectoryPath = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationColocatedHaPolicy(ReplicationColocatedHAPolicy value) {
		this.subresources.replicationColocatedHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationColocatedHaPolicy(
			ReplicationColocatedHAPolicyConsumer consumer) {
		ReplicationColocatedHAPolicy<? extends ReplicationColocatedHAPolicy> child = new ReplicationColocatedHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.replicationColocatedHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationColocatedHaPolicy() {
		ReplicationColocatedHAPolicy<? extends ReplicationColocatedHAPolicy> child = new ReplicationColocatedHAPolicy<>();
		this.subresources.replicationColocatedHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationColocatedHaPolicy(
			ReplicationColocatedHAPolicySupplier supplier) {
		this.subresources.replicationColocatedHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T journalDirectoryPath(JournalDirectoryPath value) {
		this.subresources.journalDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T journalDirectoryPath(JournalDirectoryPathConsumer consumer) {
		JournalDirectoryPath<? extends JournalDirectoryPath> child = new JournalDirectoryPath<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.journalDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T journalDirectoryPath() {
		JournalDirectoryPath<? extends JournalDirectoryPath> child = new JournalDirectoryPath<>();
		this.subresources.journalDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T journalDirectoryPath(JournalDirectoryPathSupplier supplier) {
		this.subresources.journalDirectoryPath = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreSlaveHaPolicy(SharedStoreSlaveHAPolicy value) {
		this.subresources.sharedStoreSlaveHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreSlaveHaPolicy(SharedStoreSlaveHAPolicyConsumer consumer) {
		SharedStoreSlaveHAPolicy<? extends SharedStoreSlaveHAPolicy> child = new SharedStoreSlaveHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.sharedStoreSlaveHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreSlaveHaPolicy() {
		SharedStoreSlaveHAPolicy<? extends SharedStoreSlaveHAPolicy> child = new SharedStoreSlaveHAPolicy<>();
		this.subresources.sharedStoreSlaveHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreSlaveHaPolicy(SharedStoreSlaveHAPolicySupplier supplier) {
		this.subresources.sharedStoreSlaveHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pagingDirectoryPath(PagingDirectoryPath value) {
		this.subresources.pagingDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pagingDirectoryPath(PagingDirectoryPathConsumer consumer) {
		PagingDirectoryPath<? extends PagingDirectoryPath> child = new PagingDirectoryPath<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.pagingDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pagingDirectoryPath() {
		PagingDirectoryPath<? extends PagingDirectoryPath> child = new PagingDirectoryPath<>();
		this.subresources.pagingDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pagingDirectoryPath(PagingDirectoryPathSupplier supplier) {
		this.subresources.pagingDirectoryPath = supplier.get();
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T largeMessagesDirectoryPath(LargeMessagesDirectoryPath value) {
		this.subresources.largeMessagesDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T largeMessagesDirectoryPath(
			LargeMessagesDirectoryPathConsumer consumer) {
		LargeMessagesDirectoryPath<? extends LargeMessagesDirectoryPath> child = new LargeMessagesDirectoryPath<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.largeMessagesDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T largeMessagesDirectoryPath() {
		LargeMessagesDirectoryPath<? extends LargeMessagesDirectoryPath> child = new LargeMessagesDirectoryPath<>();
		this.subresources.largeMessagesDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T largeMessagesDirectoryPath(
			LargeMessagesDirectoryPathSupplier supplier) {
		this.subresources.largeMessagesDirectoryPath = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T liveOnlyHaPolicy(LiveOnlyHAPolicy value) {
		this.subresources.liveOnlyHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T liveOnlyHaPolicy(LiveOnlyHAPolicyConsumer consumer) {
		LiveOnlyHAPolicy<? extends LiveOnlyHAPolicy> child = new LiveOnlyHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.liveOnlyHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T liveOnlyHaPolicy() {
		LiveOnlyHAPolicy<? extends LiveOnlyHAPolicy> child = new LiveOnlyHAPolicy<>();
		this.subresources.liveOnlyHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T liveOnlyHaPolicy(LiveOnlyHAPolicySupplier supplier) {
		this.subresources.liveOnlyHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationSlaveHaPolicy(ReplicationSlaveHAPolicy value) {
		this.subresources.replicationSlaveHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationSlaveHaPolicy(ReplicationSlaveHAPolicyConsumer consumer) {
		ReplicationSlaveHAPolicy<? extends ReplicationSlaveHAPolicy> child = new ReplicationSlaveHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.replicationSlaveHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationSlaveHaPolicy() {
		ReplicationSlaveHAPolicy<? extends ReplicationSlaveHAPolicy> child = new ReplicationSlaveHAPolicy<>();
		this.subresources.replicationSlaveHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationSlaveHaPolicy(ReplicationSlaveHAPolicySupplier supplier) {
		this.subresources.replicationSlaveHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for Server
	 */
	public static class ServerResources {
		/**
		 * TODO
		 */
		private List<ConnectorService> connectorServices = new java.util.ArrayList<>();
		/**
		 * Defines a way in which remote connections can be made to the ActiveMQ
		 * server over HTTP.
		 */
		private List<HTTPAcceptor> httpAcceptors = new java.util.ArrayList<>();
		/**
		 * Cluster connections group servers into clusters so that messages can
		 * be load balanced between the nodes of the cluster.
		 */
		private List<ClusterConnection> clusterConnections = new java.util.ArrayList<>();
		/**
		 * A broadcast group is the means by which a server broadcasts
		 * connectors over the network.
		 */
		private List<BroadcastGroup> broadcastGroups = new java.util.ArrayList<>();
		/**
		 * A Queue.
		 */
		private List<RuntimeQueue> runtimeQueues = new java.util.ArrayList<>();
		/**
		 * An address setting defines some attributes that are defined against
		 * an address wildcard rather than a specific queue.
		 */
		private List<AddressSetting> addressSettings = new java.util.ArrayList<>();
		/**
		 * Defines a JMS queue.
		 */
		private List<JMSQueue> jmsQueues = new java.util.ArrayList<>();
		/**
		 * Defines a managed connection factory.
		 */
		private List<PooledConnectionFactory> pooledConnectionFactories = new java.util.ArrayList<>();
		/**
		 * A messaging resource that allows you to transparently divert messages
		 * routed to one address to some other address, without making any
		 * changes to any client application logic.
		 */
		private List<Divert> diverts = new java.util.ArrayList<>();
		/**
		 * Defines a way in which in-VM connections can be made to the ActiveMQ
		 * server.
		 */
		private List<InVMAcceptor> inVmAcceptors = new java.util.ArrayList<>();
		/**
		 * Multicast group to listen to receive broadcast from other servers
		 * announcing their connectors.
		 */
		private List<DiscoveryGroup> discoveryGroups = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server over
		 * HTTP.
		 */
		private List<HTTPConnector> httpConnectors = new java.util.ArrayList<>();
		/**
		 * Defines a connection factory.
		 */
		private List<ConnectionFactory> connectionFactories = new java.util.ArrayList<>();
		/**
		 * An acceptor defines a way in which connections can be made to the
		 * ActiveMQ server.
		 */
		private List<Acceptor> acceptors = new java.util.ArrayList<>();
		/**
		 * Defines a way in which remote connections can be made to the ActiveMQ
		 * server.
		 */
		private List<RemoteAcceptor> remoteAcceptors = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server.
		 */
		private List<RemoteConnector> remoteConnectors = new java.util.ArrayList<>();
		/**
		 * Used by an in-VM client to define how it connects to a server.
		 */
		private List<InVMConnector> inVmConnectors = new java.util.ArrayList<>();
		/**
		 * Defines a connection factory.
		 */
		private List<LegacyConnectionFactory> legacyConnectionFactories = new java.util.ArrayList<>();
		/**
		 * Makes decisions about which node in a cluster should handle a message
		 * with a group id assigned.
		 */
		private List<GroupingHandler> groupingHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a JMS topic.
		 */
		private List<JMSTopic> jmsTopics = new java.util.ArrayList<>();
		/**
		 * A connector can be used by a client to define how it connects to a
		 * server.
		 */
		private List<Connector> connectors = new java.util.ArrayList<>();
		/**
		 * A security setting allows sets of permissions to be defined against
		 * queues based on their address.
		 */
		private List<SecuritySetting> securitySettings = new java.util.ArrayList<>();
		/**
		 * A runtime-only resource representing a ActiveMQ "address". Zero or
		 * more queues can be bound to a single address. When a message is
		 * routed, it is routed to the set of queues bound to the message's
		 * address.
		 */
		private List<CoreAddress> coreAddress = new java.util.ArrayList<>();
		/**
		 * The function of a bridge is to consume messages from a source queue,
		 * and forward them to a target address, typically on a different
		 * ActiveMQ server.
		 */
		private List<Bridge> bridges = new java.util.ArrayList<>();
		/**
		 * A Queue.
		 */
		private List<Queue> queues = new java.util.ArrayList<>();
		private SharedStoreColocatedHAPolicy sharedStoreColocatedHaPolicy;
		private ReplicationMasterHAPolicy replicationMasterHaPolicy;
		private SharedStoreMasterHAPolicy sharedStoreMasterHaPolicy;
		private BindingsDirectoryPath bindingsDirectoryPath;
		private ReplicationColocatedHAPolicy replicationColocatedHaPolicy;
		private JournalDirectoryPath journalDirectoryPath;
		private SharedStoreSlaveHAPolicy sharedStoreSlaveHaPolicy;
		private PagingDirectoryPath pagingDirectoryPath;
		private LargeMessagesDirectoryPath largeMessagesDirectoryPath;
		private LiveOnlyHAPolicy liveOnlyHaPolicy;
		private ReplicationSlaveHAPolicy replicationSlaveHaPolicy;

		/**
		 * Get the list of ConnectorService resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectorService> connectorServices() {
			return this.connectorServices;
		}

		public ConnectorService connectorService(String key) {
			return this.connectorServices.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of HTTPAcceptor resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<HTTPAcceptor> httpAcceptors() {
			return this.httpAcceptors;
		}

		public HTTPAcceptor httpAcceptor(String key) {
			return this.httpAcceptors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ClusterConnection resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ClusterConnection> clusterConnections() {
			return this.clusterConnections;
		}

		public ClusterConnection clusterConnection(String key) {
			return this.clusterConnections.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of BroadcastGroup resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<BroadcastGroup> broadcastGroups() {
			return this.broadcastGroups;
		}

		public BroadcastGroup broadcastGroup(String key) {
			return this.broadcastGroups.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of RuntimeQueue resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RuntimeQueue> runtimeQueues() {
			return this.runtimeQueues;
		}

		public RuntimeQueue runtimeQueue(String key) {
			return this.runtimeQueues.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AddressSetting resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AddressSetting> addressSettings() {
			return this.addressSettings;
		}

		public AddressSetting addressSetting(String key) {
			return this.addressSettings.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of JMSQueue resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<JMSQueue> jmsQueues() {
			return this.jmsQueues;
		}

		public JMSQueue jmsQueue(String key) {
			return this.jmsQueues.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of PooledConnectionFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PooledConnectionFactory> pooledConnectionFactories() {
			return this.pooledConnectionFactories;
		}

		public PooledConnectionFactory pooledConnectionFactory(String key) {
			return this.pooledConnectionFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Divert resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Divert> diverts() {
			return this.diverts;
		}

		public Divert divert(String key) {
			return this.diverts.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of InVMAcceptor resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<InVMAcceptor> inVmAcceptors() {
			return this.inVmAcceptors;
		}

		public InVMAcceptor inVmAcceptor(String key) {
			return this.inVmAcceptors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of DiscoveryGroup resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<DiscoveryGroup> discoveryGroups() {
			return this.discoveryGroups;
		}

		public DiscoveryGroup discoveryGroup(String key) {
			return this.discoveryGroups.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of HTTPConnector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<HTTPConnector> httpConnectors() {
			return this.httpConnectors;
		}

		public HTTPConnector httpConnector(String key) {
			return this.httpConnectors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConnectionFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectionFactory> connectionFactories() {
			return this.connectionFactories;
		}

		public ConnectionFactory connectionFactory(String key) {
			return this.connectionFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Acceptor resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Acceptor> acceptors() {
			return this.acceptors;
		}

		public Acceptor acceptor(String key) {
			return this.acceptors.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of RemoteAcceptor resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteAcceptor> remoteAcceptors() {
			return this.remoteAcceptors;
		}

		public RemoteAcceptor remoteAcceptor(String key) {
			return this.remoteAcceptors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of RemoteConnector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteConnector> remoteConnectors() {
			return this.remoteConnectors;
		}

		public RemoteConnector remoteConnector(String key) {
			return this.remoteConnectors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of InVMConnector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<InVMConnector> inVmConnectors() {
			return this.inVmConnectors;
		}

		public InVMConnector inVmConnector(String key) {
			return this.inVmConnectors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of LegacyConnectionFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LegacyConnectionFactory> legacyConnectionFactories() {
			return this.legacyConnectionFactories;
		}

		public LegacyConnectionFactory legacyConnectionFactory(String key) {
			return this.legacyConnectionFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of GroupingHandler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<GroupingHandler> groupingHandlers() {
			return this.groupingHandlers;
		}

		public GroupingHandler groupingHandler(String key) {
			return this.groupingHandlers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of JMSTopic resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<JMSTopic> jmsTopics() {
			return this.jmsTopics;
		}

		public JMSTopic jmsTopic(String key) {
			return this.jmsTopics.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of Connector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Connector> connectors() {
			return this.connectors;
		}

		public Connector connector(String key) {
			return this.connectors.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of SecuritySetting resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SecuritySetting> securitySettings() {
			return this.securitySettings;
		}

		public SecuritySetting securitySetting(String key) {
			return this.securitySettings.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CoreAddress resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CoreAddress> coreAddress() {
			return this.coreAddress;
		}

		public CoreAddress coreAddress(String key) {
			return this.coreAddress.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Bridge resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Bridge> bridges() {
			return this.bridges;
		}

		public Bridge bridge(String key) {
			return this.bridges.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of Queue resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Queue> queues() {
			return this.queues;
		}

		public Queue queue(String key) {
			return this.queues.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public SharedStoreColocatedHAPolicy sharedStoreColocatedHaPolicy() {
			return this.sharedStoreColocatedHaPolicy;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public ReplicationMasterHAPolicy replicationMasterHaPolicy() {
			return this.replicationMasterHaPolicy;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public SharedStoreMasterHAPolicy sharedStoreMasterHaPolicy() {
			return this.sharedStoreMasterHaPolicy;
		}

		/**
		 * A filesystem path pointing to one of the locations where ActiveMQ
		 * stores persistent data.
		 */
		@Subresource
		public BindingsDirectoryPath bindingsDirectoryPath() {
			return this.bindingsDirectoryPath;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public ReplicationColocatedHAPolicy replicationColocatedHaPolicy() {
			return this.replicationColocatedHaPolicy;
		}

		/**
		 * A filesystem path pointing to one of the locations where ActiveMQ
		 * stores persistent data.
		 */
		@Subresource
		public JournalDirectoryPath journalDirectoryPath() {
			return this.journalDirectoryPath;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public SharedStoreSlaveHAPolicy sharedStoreSlaveHaPolicy() {
			return this.sharedStoreSlaveHaPolicy;
		}

		/**
		 * A filesystem path pointing to one of the locations where ActiveMQ
		 * stores persistent data.
		 */
		@Subresource
		public PagingDirectoryPath pagingDirectoryPath() {
			return this.pagingDirectoryPath;
		}

		/**
		 * A filesystem path pointing to one of the locations where ActiveMQ
		 * stores persistent data.
		 */
		@Subresource
		public LargeMessagesDirectoryPath largeMessagesDirectoryPath() {
			return this.largeMessagesDirectoryPath;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public LiveOnlyHAPolicy liveOnlyHaPolicy() {
			return this.liveOnlyHaPolicy;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public ReplicationSlaveHAPolicy replicationSlaveHaPolicy() {
			return this.replicationSlaveHaPolicy;
		}
	}

	public static enum JournalType {
		NIO("NIO"), ASYNCIO("ASYNCIO");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		JournalType(String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}
}