package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * TODO
 */
@Address("/subsystem=messaging-activemq/server=*/connector-service=*")
@ResourceType("connector-service")
public class ConnectorService<T extends ConnectorService<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String factoryClass;
	private Map params;

	public ConnectorService(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Class name of the factory class that can instantiate the connector
	 * service.
	 */
	@ModelNodeBinding(detypedName = "factory-class")
	public String factoryClass() {
		return this.factoryClass;
	}

	/**
	 * Class name of the factory class that can instantiate the connector
	 * service.
	 */
	@SuppressWarnings("unchecked")
	public T factoryClass(String value) {
		Object oldValue = this.factoryClass;
		this.factoryClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("factoryClass", oldValue, value);
		return (T) this;
	}

	/**
	 * A key/value pair understood by the connector service's factory-class
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key/value pair understood by the connector service's factory-class
	 */
	@SuppressWarnings("unchecked")
	public T params(Map value) {
		Object oldValue = this.params;
		this.params = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("params", oldValue, value);
		return (T) this;
	}

	/**
	 * A key/value pair understood by the connector service's factory-class
	 */
	public T param(String key, Object value) {
		if (this.params == null) {
			this.params = new java.util.HashMap<>();
		}
		this.params.put(key, value);
		return (T) this;
	}
}