package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.JournalDirectoryPath;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface JournalDirectoryPathConsumer<T extends JournalDirectoryPath<T>> {

	/**
	 * Configure a pre-constructed instance of JournalDirectoryPath resource
	 * 
	 * @parameter Instance of JournalDirectoryPath to configure
	 * @return nothing
	 */
	void accept(T value);

	default JournalDirectoryPathConsumer<T> andThen(
			JournalDirectoryPathConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}