package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.PagingDirectoryPath;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface PagingDirectoryPathConsumer<T extends PagingDirectoryPath<T>> {

	/**
	 * Configure a pre-constructed instance of PagingDirectoryPath resource
	 * 
	 * @parameter Instance of PagingDirectoryPath to configure
	 * @return nothing
	 */
	void accept(T value);

	default PagingDirectoryPathConsumer<T> andThen(
			PagingDirectoryPathConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}